/**
 * ogma_reg_f_gmac_4mt.h
 *
 *  Copyright (c) 2012 - 2015 SOCIONEXT INCORPORATED.
 *  All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#ifndef OGMA_REG_F_GMAC_4MT_H
#define OGMA_REG_F_GMAC_4MT_H

/**
 * GMAC regtister
 */
#define OGMA_GMAC_REG_ADDR_MCR      (0x0000)
#define OGMA_GMAC_REG_ADDR_MFFR     (0x0004)
#define OGMA_GMAC_REG_ADDR_MHTRH    (0x0008)
#define OGMA_GMAC_REG_ADDR_MHTRL    (0x000c)
#define OGMA_GMAC_REG_ADDR_GAR      (0x0010)
#define OGMA_GMAC_REG_ADDR_GDR      (0x0014)
#define OGMA_GMAC_REG_ADDR_FCR      (0x0018)
#define OGMA_GMAC_REG_ADDR_VTR      (0x001c)
#define OGMA_GMAC_REG_ADDR_RWFFR    (0x0028)
#define OGMA_GMAC_REG_ADDR_PMTR     (0x002c)
#define OGMA_GMAC_REG_ADDR_LPICSR   (0x0030)
#define OGMA_GMAC_REG_ADDR_LPITCR   (0x0034)
#define OGMA_GMAC_REG_ADDR_ISR      (0x0038)
#define OGMA_GMAC_REG_ADDR_IMR      (0x003c)
#define OGMA_GMAC_REG_ADDR_MAR0H    (0x0040)
#define OGMA_GMAC_REG_ADDR_MAR0L    (0x0044)
#define OGMA_GMAC_REG_ADDR_MAR1H    (0x0048)
#define OGMA_GMAC_REG_ADDR_MAR1L    (0x004c)
#define OGMA_GMAC_REG_ADDR_MAR2H    (0x0050)
#define OGMA_GMAC_REG_ADDR_MAR2L    (0x0054)
#define OGMA_GMAC_REG_ADDR_MAR3H    (0x0058)
#define OGMA_GMAC_REG_ADDR_MAR3L    (0x005c)
#define OGMA_GMAC_REG_ADDR_MAR4H    (0x0060)
#define OGMA_GMAC_REG_ADDR_MAR4L    (0x0064)
#define OGMA_GMAC_REG_ADDR_MAR5H    (0x0068)
#define OGMA_GMAC_REG_ADDR_MAR5L    (0x006c)
#define OGMA_GMAC_REG_ADDR_MAR6H    (0x0070)
#define OGMA_GMAC_REG_ADDR_MAR6L    (0x0074)
#define OGMA_GMAC_REG_ADDR_MAR7H    (0x0078)
#define OGMA_GMAC_REG_ADDR_MAR7L    (0x007c)
#define OGMA_GMAC_REG_ADDR_MAR8H    (0x0080)
#define OGMA_GMAC_REG_ADDR_MAR8L    (0x0084)
#define OGMA_GMAC_REG_ADDR_MAR9H    (0x0088)
#define OGMA_GMAC_REG_ADDR_MAR9L    (0x008c)
#define OGMA_GMAC_REG_ADDR_MAR10H   (0x0090)
#define OGMA_GMAC_REG_ADDR_MAR10L   (0x0094)
#define OGMA_GMAC_REG_ADDR_MAR11H   (0x0098)
#define OGMA_GMAC_REG_ADDR_MAR11L   (0x009c)
#define OGMA_GMAC_REG_ADDR_MAR12H   (0x00a0)
#define OGMA_GMAC_REG_ADDR_MAR12L   (0x00a4)
#define OGMA_GMAC_REG_ADDR_MAR13H   (0x00a8)
#define OGMA_GMAC_REG_ADDR_MAR13L   (0x00ac)
#define OGMA_GMAC_REG_ADDR_MAR14H   (0x00b0)
#define OGMA_GMAC_REG_ADDR_MAR14L   (0x00b4)
#define OGMA_GMAC_REG_ADDR_MAR15H   (0x00b8)
#define OGMA_GMAC_REG_ADDR_MAR15L   (0x00bc)
#define OGMA_GMAC_REG_ADDR_RSR      (0x00d8)
#define OGMA_GMAC_REG_ADDR_TSCR     (0x0700)
#define OGMA_GMAC_REG_ADDR_SSIR     (0x0704)
#define OGMA_GMAC_REG_ADDR_STSR     (0x0708)
#define OGMA_GMAC_REG_ADDR_STNR     (0x070c)
#define OGMA_GMAC_REG_ADDR_STSUR    (0x0710)
#define OGMA_GMAC_REG_ADDR_STNUR    (0x0714)
#define OGMA_GMAC_REG_ADDR_TSAR     (0x0718)
#define OGMA_GMAC_REG_ADDR_TTSR     (0x071c)
#define OGMA_GMAC_REG_ADDR_TTNR     (0x0720)
#define OGMA_GMAC_REG_ADDR_STHWSR   (0x0724)
#define OGMA_GMAC_REG_ADDR_TSR      (0x0728)
#define OGMA_GMAC_REG_ADDR_PPSCR    (0x072c)
#define OGMA_GMAC_REG_ADDR_ANTR     (0x0730)
#define OGMA_GMAC_REG_ADDR_ATSR     (0x0734)
#define OGMA_GMAC_REG_ADDR_MAR16H   (0x0800)
#define OGMA_GMAC_REG_ADDR_MAR16L   (0x0804)
#define OGMA_GMAC_REG_ADDR_MAR17H   (0x0808)
#define OGMA_GMAC_REG_ADDR_MAR17L   (0x080c)
#define OGMA_GMAC_REG_ADDR_MAR18H   (0x0810)
#define OGMA_GMAC_REG_ADDR_MAR18L   (0x0814)
#define OGMA_GMAC_REG_ADDR_MAR19H   (0x0818)
#define OGMA_GMAC_REG_ADDR_MAR19L   (0x081c)
#define OGMA_GMAC_REG_ADDR_MAR20H   (0x0820)
#define OGMA_GMAC_REG_ADDR_MAR20L   (0x0824)
#define OGMA_GMAC_REG_ADDR_MAR21H   (0x0828)
#define OGMA_GMAC_REG_ADDR_MAR21L   (0x082c)
#define OGMA_GMAC_REG_ADDR_MAR22H   (0x0830)
#define OGMA_GMAC_REG_ADDR_MAR22L   (0x0834)
#define OGMA_GMAC_REG_ADDR_MAR23H   (0x0838)
#define OGMA_GMAC_REG_ADDR_MAR23L   (0x083c)
#define OGMA_GMAC_REG_ADDR_MAR24H   (0x0840)
#define OGMA_GMAC_REG_ADDR_MAR24L   (0x0844)
#define OGMA_GMAC_REG_ADDR_MAR25H   (0x0848)
#define OGMA_GMAC_REG_ADDR_MAR25L   (0x084c)
#define OGMA_GMAC_REG_ADDR_MAR26H   (0x0850)
#define OGMA_GMAC_REG_ADDR_MAR26L   (0x0854)
#define OGMA_GMAC_REG_ADDR_MAR27H   (0x0858)
#define OGMA_GMAC_REG_ADDR_MAR27L   (0x085c)
#define OGMA_GMAC_REG_ADDR_MAR28H   (0x0860)
#define OGMA_GMAC_REG_ADDR_MAR28L   (0x0864)
#define OGMA_GMAC_REG_ADDR_MAR29H   (0x0868)
#define OGMA_GMAC_REG_ADDR_MAR29L   (0x086c)
#define OGMA_GMAC_REG_ADDR_MAR30H   (0x0870)
#define OGMA_GMAC_REG_ADDR_MAR30L   (0x0874)
#define OGMA_GMAC_REG_ADDR_MAR31H   (0x0878)
#define OGMA_GMAC_REG_ADDR_MAR31L   (0x087c)

/**
 * GMAC MAC Management Counters(Option) register
 */
#define OGMA_GMAC_REG_ADDR_MMC_CNTL                  (0x0100)
#define OGMA_GMAC_REG_ADDR_MMC_INTR_RX               (0x0104)
#define OGMA_GMAC_REG_ADDR_MMC_INTR_TX               (0x0108)
#define OGMA_GMAC_REG_ADDR_MMC_INTR_MASK_RX          (0x010c)
#define OGMA_GMAC_REG_ADDR_MMC_INTR_MASK_TX          (0x0110)
#define OGMA_GMAC_REG_ADDR_TXOCTETCOUNT_GB           (0x0114)
#define OGMA_GMAC_REG_ADDR_TXFRAMECOUNT_GB           (0x0118)
#define OGMA_GMAC_REG_ADDR_TXBROADCASTFRAMES_G       (0x011c)
#define OGMA_GMAC_REG_ADDR_TXMULTICASTFRAMES_G       (0x0120)
#define OGMA_GMAC_REG_ADDR_TX64OCTETS_GB             (0x0124)
#define OGMA_GMAC_REG_ADDR_TX65TO127OCTETS_GB        (0x0128)
#define OGMA_GMAC_REG_ADDR_TX128TO255OCTETS_GB       (0x012c)
#define OGMA_GMAC_REG_ADDR_TX256TO511OCTETS_GB       (0x0130)
#define OGMA_GMAC_REG_ADDR_TX512TO1023OCTETS_GB      (0x0134)
#define OGMA_GMAC_REG_ADDR_TX1024TOMAXOCTETS_GB      (0x0138)
#define OGMA_GMAC_REG_ADDR_TXUNICASTFRAMES_GB        (0x013c)
#define OGMA_GMAC_REG_ADDR_TXMULTICASTFRAMES_GB      (0x0140)
#define OGMA_GMAC_REG_ADDR_TXBROADCASTFRAMES_GB      (0x0144)
#define OGMA_GMAC_REG_ADDR_TXUNDERFLOWERROR          (0x0148)
#define OGMA_GMAC_REG_ADDR_TXSINGLECOL_G             (0x014c)
#define OGMA_GMAC_REG_ADDR_TXMULTICOL_G              (0x0150)
#define OGMA_GMAC_REG_ADDR_TXDEFERRED                (0x0154)
#define OGMA_GMAC_REG_ADDR_TXLATECOL                 (0x0158)
#define OGMA_GMAC_REG_ADDR_TXEXESSCOL                (0x015c)
#define OGMA_GMAC_REG_ADDR_TXCARRIERERRROR           (0x0160)
#define OGMA_GMAC_REG_ADDR_TXOCTETCOUNT_G            (0x0164)
#define OGMA_GMAC_REG_ADDR_TXFRAMECOUNT_G            (0x0168)
#define OGMA_GMAC_REG_ADDR_TXEXECESSDEF              (0x016c)
#define OGMA_GMAC_REG_ADDR_TXPAUSEFRAMES             (0x0170)
#define OGMA_GMAC_REG_ADDR_TXVLANFRAMES_G            (0x0174)
#define OGMA_GMAC_REG_ADDR_RXFRAMECOUNT_GB           (0x0180)
#define OGMA_GMAC_REG_ADDR_RXOCTETCOUNT_GB           (0x0184)
#define OGMA_GMAC_REG_ADDR_RXOCTETCOUNT_G            (0x0188)
#define OGMA_GMAC_REG_ADDR_RXBROADCASTFRAMES_G       (0x018c)
#define OGMA_GMAC_REG_ADDR_RXMULTICASTFRAMES_G       (0x0190)
#define OGMA_GMAC_REG_ADDR_RXCRCERROR                (0x0194)
#define OGMA_GMAC_REG_ADDR_RXALLIGNMENTERROR         (0x0198)
#define OGMA_GMAC_REG_ADDR_RXRUNTERROR               (0x019c)
#define OGMA_GMAC_REG_ADDR_RXJABBERERROR             (0x01a0)
#define OGMA_GMAC_REG_ADDR_RXUNDERSIZE_G             (0x01a4)
#define OGMA_GMAC_REG_ADDR_RXOVERSIZE_G              (0x01a8)
#define OGMA_GMAC_REG_ADDR_RX64OCTETS_GB             (0x01ac)
#define OGMA_GMAC_REG_ADDR_RX65TO127OCTETS_GB        (0x01b0)
#define OGMA_GMAC_REG_ADDR_RX128TO255OCTETS_GB       (0x01b4)
#define OGMA_GMAC_REG_ADDR_RX256TO511OCTETS_GB       (0x01b8)
#define OGMA_GMAC_REG_ADDR_RX512TO1023OCTETS_GB      (0x01bc)
#define OGMA_GMAC_REG_ADDR_RX1024TOMAXOCTETS_GB      (0x01c0)
#define OGMA_GMAC_REG_ADDR_RXUNICASTFRAMES_G         (0x01c4)
#define OGMA_GMAC_REG_ADDR_RXLENGTHERROR             (0x01c8)
#define OGMA_GMAC_REG_ADDR_RXOUTOFRANGETYPE          (0x01cc)
#define OGMA_GMAC_REG_ADDR_RXPAUSEFRAMES             (0x01d0)
#define OGMA_GMAC_REG_ADDR_RXFIFOOVERFLOW            (0x01d4)
#define OGMA_GMAC_REG_ADDR_RXVLANFRAMES_GB           (0x01d8)
#define OGMA_GMAC_REG_ADDR_RXWATCHDOGERROR           (0x01dc)
#define OGMA_GMAC_REG_ADDR_MMC_IPC_INTR_MASK_RX      (0x0200)
#define OGMA_GMAC_REG_ADDR_MMC_IPC_INTR_RX           (0x0208)
#define OGMA_GMAC_REG_ADDR_RXIPV4_GD_FRMS            (0x0210)
#define OGMA_GMAC_REG_ADDR_RXIPV4_HDRERR_FRMS        (0x0214)
#define OGMA_GMAC_REG_ADDR_RXIPV4_NOPAY_FRMS         (0x0218)
#define OGMA_GMAC_REG_ADDR_RXIPV4_FRAG_FRMS          (0x021c)
#define OGMA_GMAC_REG_ADDR_RXIPV4_UDSBL_FRMS         (0x0220)
#define OGMA_GMAC_REG_ADDR_RXIPV6_GD_FRMS            (0x0224)
#define OGMA_GMAC_REG_ADDR_RXIPV6_HDRERR_FRMS        (0x0228)
#define OGMA_GMAC_REG_ADDR_RXIPV6_NOPAY_FRMS         (0x022c)
#define OGMA_GMAC_REG_ADDR_RXUDP_GD_FRMS             (0x0230)
#define OGMA_GMAC_REG_ADDR_RXUDP_ERR_FRMS            (0x0234)
#define OGMA_GMAC_REG_ADDR_RXTCP_GD_FRMS             (0x0238)
#define OGMA_GMAC_REG_ADDR_RXTCP_ERR_FRMS            (0x023c)
#define OGMA_GMAC_REG_ADDR_RXICMP_GD_FRMS            (0x0240)
#define OGMA_GMAC_REG_ADDR_RXICMP_ERR_FRMS           (0x0244)
#define OGMA_GMAC_REG_ADDR_RXIPV4_GD_OCTETS          (0x0250)
#define OGMA_GMAC_REG_ADDR_RXIPV4_HDRERR_OCTETS      (0x0254)
#define OGMA_GMAC_REG_ADDR_RXIPV4_NOPAY_OCTETS       (0x0258)
#define OGMA_GMAC_REG_ADDR_RXIPV4_FRAG_OCTETS        (0x025c)
#define OGMA_GMAC_REG_ADDR_RXIPV4_UDSBL_OCTETS       (0x0260)
#define OGMA_GMAC_REG_ADDR_RXIPV6_GD_OCTETS          (0x0264)
#define OGMA_GMAC_REG_ADDR_RXIPV6_HDRERR_OCTETS      (0x0268)
#define OGMA_GMAC_REG_ADDR_RXIPV6_NOPAY_OCTETS       (0x026c)
#define OGMA_GMAC_REG_ADDR_RXUDP_GD_OCTETS           (0x0270)
#define OGMA_GMAC_REG_ADDR_RXUDP_ERR_OCTETS          (0x0274)
#define OGMA_GMAC_REG_ADDR_RXTCP_GD_OCTETS           (0x0278)
#define OGMA_GMAC_REG_ADDR_RXTCP_ERR_OCTETS          (0x027c)
#define OGMA_GMAC_REG_ADDR_RXICMP_GD_OCTETS          (0x0280)
#define OGMA_GMAC_REG_ADDR_RXICMP_ERR_OCTETS         (0x0284)
/**
 * GMAC DMA register
 */
#define OGMA_GMAC_REG_ADDR_BMR      (0x1000)
#define OGMA_GMAC_REG_ADDR_TPDR     (0x1004)
#define OGMA_GMAC_REG_ADDR_RPDR     (0x1008)
#define OGMA_GMAC_REG_ADDR_RDLAR    (0x100c)
#define OGMA_GMAC_REG_ADDR_TDLAR    (0x1010)
#define OGMA_GMAC_REG_ADDR_SR       (0x1014)
#define OGMA_GMAC_REG_ADDR_OMR      (0x1018)
#define OGMA_GMAC_REG_ADDR_IER      (0x101c)
#define OGMA_GMAC_REG_ADDR_MFOCR    (0x1020)
#define OGMA_GMAC_REG_ADDR_RIWTR    (0x1024)
#define OGMA_GMAC_REG_ADDR_AHBSR    (0x102c)
#define OGMA_GMAC_REG_ADDR_CHTDR    (0x1048)
#define OGMA_GMAC_REG_ADDR_CHRDR    (0x104c)
#define OGMA_GMAC_REG_ADDR_CHTBAR   (0x1050)
#define OGMA_GMAC_REG_ADDR_CHRBAR   (0x1054)

#endif				/* OGMA_REG_F_GMAC_4MT_H */
