/*
 * f_hdmy_14tx  HDMI 1.4 PHY driver
 * Copyright (C) 2013 Linaro, Ltd
 * Author: Andy Green <andy.green@linaro.org>
 */

#ifndef ___LINUX_VIDEO_F_HDMI_14TX_H__
#define ___LINUX_VIDEO_F_HDMI_14TX_H__

#include <video/fdb.h>

enum {
	FHT14_BASE_VND_IDL_OFS = 0x0,
	FHT14_BASE_VND_IDH_OFS = 0x1,
	FHT14_BASE_DEV_IDL_OFS = 0x2,
	FHT14_BASE_DEV_IDH_OFS = 0x3,
	FHT14_BASE_DEV_REV_OFS = 0x4,
	FHT14_BASE_SRST_OFS = 0x5,
	FHT14_BASE_SYS_CTRL1_OFS = 0x8,
	FHT14_BASE_SYS_STAT_OFS = 0x9,
	FHT14_BASE_SYS_CTRL3_OFS = 0xa,
	FHT14_BASE_SYS_DCTL_OFS = 0xd,

	/* HDCP-related not supported */

	FHT14_VDE_DE_DLY_OFS = 0x32,
	FHT14_VDE_DE_CTRL_OFS = 0x33,
	FHT14_VDE_DE_TOP_OFS = 0x34,
	FHT14_VDE_DE_CNTL_OFS = 0x36,
	FHT14_VDE_DE_CNTH_OFS = 0x37,
	FHT14_VDE_DE_LINL_OFS = 0x38,
	FHT14_VDE_DE_LINH_OFS = 0x39,
	FHT14_VDE_DE_HRESL_OFS = 0x3a,
	FHT14_VDE_DE_HRESH_OFS = 0x3b,
	FHT14_VDE_DE_VRESL_OFS = 0x3c,
	FHT14_VDE_DE_VRESH_OFS = 0x3d,

	FHT14_VDE_IADJUST_OFS = 0x3e,
	FHT14_VDE_POL_DETECT_OFS = 0x3f,
	FHT14_VDE_HBIT_TO_HSYNC_L_OFS = 0x40,
	FHT14_VDE_HBIT_TO_HSYNC_H_OFS = 0x41,
	FHT14_VDE_FIELD2_OFST_L_OFS = 0x42,
	FHT14_VDE_FIELD2_OFST_H_OFS = 0x43,
	FHT14_VDE_HWIDTH_L_OFS = 0x44,
	FHT14_VDE_HWIDTH_H_OFS = 0x45,
	FHT14_VDE_VBIT_TO_VSYNC_OFS = 0x46,
	FHT14_VDE_VWIDTH_OFS = 0x47,
	FHT14_VDE_VID_CTRL_OFS = 0x48,
	FHT14_VDE_VID_ACEN_OFS = 0x49,
	FHT14_VDE_VID_MODE_OFS = 0x4a,
	FHT14_VDE_VID_BLANK1_OFS = 0x4b,
	FHT14_VDE_VID_BLANK2_OFS = 0x4c,
	FHT14_VDE_VID_BLANK3_OFS = 0x4d,
	FHT14_VDE_DC_HEADER_OFS = 0x4e,
	FHT14_VDE_VID_DITHER_OFS = 0x4f,
	FHT14_VDE_RGB_TO_XVYVV_CT_OFS = 0x50,
	FHT14_VDE_R_TO_Y_COEFF_LOW_OFS = 0x51,
	FHT14_VDE_R_TO_Y_COEFF_UP_OFS = 0x52,
	FHT14_VDE_G_TO_Y_COEFF_LOW_OFS = 0x53,
	FHT14_VDE_G_TO_Y_COEFF_UP_OFS = 0x54,
	FHT14_VDE_B_TO_Y_COEFF_LOW_OFS = 0x55,
	FHT14_VDE_B_TO_Y_COEFF_UP_OFS = 0x56,
	FHT14_VDE_R_TO_CB_COEFF_LOW_OFS = 0x57,
	FHT14_VDE_R_TO_CB_COEFF_UP_OFS = 0x58,
	FHT14_VDE_G_TO_CB_COEFF_LOW_OFS = 0x59,
	FHT14_VDE_G_TO_CB_COEFF_UP_OFS = 0x5a,
	FHT14_VDE_B_TO_CB_COEFF_LOW_OFS = 0x5b,
	FHT14_VDE_B_TO_CB_COEFF_UP_OFS = 0x5c,
	FHT14_VDE_R_TO_CR_COEFF_LOW_OFS = 0x5d,
	FHT14_VDE_R_TO_CR_COEFF_UP_OFS = 0x5e,
	FHT14_VDE_G_TO_CR_COEFF_LOW_OFS = 0x5f,
	FHT14_VDE_G_TO_CR_COEFF_UP_OFS = 0x60,
	FHT14_VDE_B_TO_CR_COEFF_LOW_OFS = 0x61,
	FHT14_VDE_B_TO_CR_COEFF_UP_OFS = 0x62,
	FHT14_VDE_RGB_OFFSET_LOW_OFS = 0x63,
	FHT14_VDE_RGB_OFFSET_UP_OFS = 0x64,
	FHT14_VDE_Y_OFFSET_LOW_OFS = 0x65,
	FHT14_VDE_Y_OFFSET_UP_OFS = 0x66,
	FHT14_VDE_CBCR_OFFSET_LOW_OFS = 0x67,
	FHT14_VDE_CBCR_OFFSET_UP_OFS = 0x68,

	FHT14_INTR_INTR_STATE_OFS = 0x70,
	FHT14_INTR_INTR1_OFS = 0x71,
	FHT14_INTR_INTR2_OFS = 0x72,
	FHT14_INTR_INTR3_OFS = 0x73,
	FHT14_INTR_INTR4_OFS = 0x74,
	FHT14_INTR_INT_UNMASK1_OFS = 0x75,
	FHT14_INTR_INT_UNMASK2_OFS = 0x76,
	FHT14_INTR_INT_UNMASK3_OFS = 0x77,
	FHT14_INTR_INT_UNMASK4_OFS = 0x78,
	FHT14_INTR_INT_CTRL_OFS = 0x79,

	FHT14_TMDS_TMDS_CTRL_OFS = 0x82,
	FHT14_TMDS_XVYCC_TO_RGB_CTL_OFS = 0x90,
	FHT14_TMDS_Y_TO_R_COEFF_LOW_OFS = 0x91,
	FHT14_TMDS_Y_TO_R_COEFF_UP_OFS = 0x92,
	FHT14_TMDS_CR_TO_R_COEFF_LOW_OFS = 0x93,
	FHT14_TMDS_CR_TO_R_COEFF_UP_OFS = 0x94,
	FHT14_TMDS_CB_TO_B_COEFF_LOW_OFS = 0x95,
	FHT14_TMDS_CB_TO_B_COEFF_UP_OFS = 0x96,
	FHT14_TMDS_CR_TO_G_COEFF_LOW_OFS = 0x97,
	FHT14_TMDS_CR_TO_G_COEFF_UP_OFS = 0x98,
	FHT14_TMDS_CB_TO_G_COEFF_LOW_OFS = 0x99,
	FHT14_TMDS_CB_TO_G_COEFF_UP_OFS = 0x9a,
	FHT14_TMDS_YOFFSET1_LOW_OFS = 0x9b,
	FHT14_TMDS_YOFFSET1_UP_OFS = 0x9c,
	FHT14_TMDS_OFFSET1_LOW_OFS = 0x9d,
	FHT14_TMDS_OFFSET1_MID_OFS = 0x9e,
	FHT14_TMDS_OFFSET1_UP_OFS = 0x9f,
	FHT14_TMDS_OFFSET2_LOW_OFS = 0xa0,
	FHT14_TMDS_OFFSET2_UP_OFS = 0xa1,
	FHT14_TMDS_DCLEVEL_LOW_OFS = 0xa2,
	FHT14_TMDS_DCLEVEL_UP_OFS = 0xa3,

	/* SHA for hdcp not supported */

	FHT14_DDC_DDC_MAN_OFS = 0xec,
	FHT14_DDC_DDC_ADDR_OFS = 0xed,
	FHT14_DDC_DDC_SEGM_OFS = 0xee,
	FHT14_DDC_DDC_OFFSET_OFS = 0xef,
	FHT14_DDC_DDC_COUNT_LOW_OFS = 0xf0,
	FHT14_DDC_DDC_COUNT_UP_OFS = 0xf1,
	FHT14_DDC_DDC_STATUS_OFS = 0xf2,
	FHT14_DDC_DDC_CMD_OFS = 0xf3,
	FHT14_DDC_DDC_DATA_OFS = 0xf4,
	FHT14_DDC_DDC_FIFOCNT_OFS = 0xf5,

	/* ROM for hdcp not supported */

	FHT14_REG_REG_BANK0_OFS = 0xff,

	FHT14_ACR_ACR_CTRL_OFS = 0x101,
	FHT14_ACR_FREQ_SVAL_OFS = 0x102,
	FHT14_ACR_N_SVAL_LOW_OFS = 0x103,
	FHT14_ACR_N_SVAL_MID_OFS = 0x104,
	FHT14_ACR_N_SVAL_UP_OFS = 0x105,
	FHT14_ACR_CTS_SVAL_LOW_OFS = 0x106,
	FHT14_ACR_CTS_SVAL_MID_OFS = 0x107,
	FHT14_ACR_CTS_SVAL_UP_OFS = 0x108,
	FHT14_ACR_CTS_HVAL_LOW_OFS = 0x109,
	FHT14_ACR_CTS_HVAL_MID_OFS = 0x10a,
	FHT14_ACR_CTS_HVAL_UP_OFS = 0x10b,
	FHT14_ACRIN_AUD_MODE_OFS = 0x114,
	FHT14_ACRIN_SPDIF_CTRL_OFS = 0x115,
	FHT14_ACRIN_HW_SPDIF_FS_OFS = 0x118,
	FHT14_ACRIN_SWAPI2S_OFS = 0x119,
	FHT14_ACRIN_SPDIF_ERTH_OFS = 0x11b,
	FHT14_ACRIN_I2S_IN_MAP_OFS = 0x11c,
	FHT14_ACRIN_I2S_IN_CTRL_OFS = 0x11d,
	FHT14_ACRIN_I2S_CHST1_OFS = 0x11e,
	FHT14_ACRIN_I2S_CHST2_OFS = 0x11f,
	FHT14_ACRIN_I2S_CHST3_OFS = 0x120,
	FHT14_ACRIN_I2S_CHST4_OFS = 0x121,
	FHT14_ACRIN_I2S_CHST5_OFS = 0x122,
	FHT14_ACRIN_ASRC_OFS = 0x123,
	FHT14_ACRIN_I2S_IN_LEN_OFS = 0x124,
	FHT14_ACR_HDMI_CTRL_OFS = 0x12f,
	FHT14_ACR_AUDO_TXSTAT_OFS = 0x130,
	FHT14_ACR_DPD_OFS = 0x13d,

	FHT14_PKT_PB_CTRL1_OFS = 0x13e,
	FHT14_PKT_PB_CTRL2_OFS = 0x13f,

	FHT14_PKT_AVI_TYPE_OFS = 0x140,
	FHT14_PKT_AVI_VERS_OFS = 0x141,
	FHT14_PKT_AVI_LEN_OFS = 0x142,
	FHT14_PKT_AVI_CHSUM_OFS = 0x143,
	FHT14_PKT_AVI_DBYTE1_OFS = 0x144,
	FHT14_PKT_AVI_DBYTE2_OFS = 0x145,
	FHT14_PKT_AVI_DBYTE3_OFS = 0x146,
	FHT14_PKT_AVI_DBYTE4_OFS = 0x147,
	FHT14_PKT_AVI_DBYTE5_OFS = 0x148,
	FHT14_PKT_AVI_DBYTE6_OFS = 0x149,
	FHT14_PKT_AVI_DBYTE7_OFS = 0x14a,
	FHT14_PKT_AVI_DBYTE8_OFS = 0x14b,
	FHT14_PKT_AVI_DBYTE9_OFS = 0x14c,
	FHT14_PKT_AVI_DBYTE10_OFS = 0x14d,
	FHT14_PKT_AVI_DBYTE11_OFS = 0x14e,
	FHT14_PKT_AVI_DBYTE12_OFS = 0x14f,
	FHT14_PKT_AVI_DBYTE13_OFS = 0x150,
	FHT14_PKT_AVI_DBYTE14_OFS = 0x151,
	FHT14_PKT_AVI_DBYTE15_OFS = 0x152,
	FHT14_PKT_SPD_TYPE_OFS = 0x160,
	FHT14_PKT_SPD_VERS_OFS = 0x161,
	FHT14_PKT_SPD_LEN_OFS = 0x162,
	FHT14_PKT_SPD_CHSUM_OFS = 0x163,
	FHT14_PKT_SPD_DBYTE1_OFS = 0x164,
	FHT14_PKT_SPD_DBYTE2_OFS = 0x165,
	FHT14_PKT_SPD_DBYTE3_OFS = 0x166,
	FHT14_PKT_SPD_DBYTE4_OFS = 0x167,
	FHT14_PKT_SPD_DBYTE5_OFS = 0x168,
	FHT14_PKT_SPD_DBYTE6_OFS = 0x169,
	FHT14_PKT_SPD_DBYTE7_OFS = 0x16a,
	FHT14_PKT_SPD_DBYTE8_OFS = 0x16b,
	FHT14_PKT_SPD_DBYTE9_OFS = 0x16c,
	FHT14_PKT_SPD_DBYTE10_OFS = 0x16d,
	FHT14_PKT_SPD_DBYTE11_OFS = 0x16e,
	FHT14_PKT_SPD_DBYTE12_OFS = 0x16f,
	FHT14_PKT_SPD_DBYTE13_OFS = 0x170,
	FHT14_PKT_SPD_DBYTE14_OFS = 0x171,
	FHT14_PKT_SPD_DBYTE15_OFS = 0x172,
	FHT14_PKT_SPD_DBYTE16_OFS = 0x173,
	FHT14_PKT_SPD_DBYTE17_OFS = 0x174,
	FHT14_PKT_SPD_DBYTE18_OFS = 0x175,
	FHT14_PKT_SPD_DBYTE19_OFS = 0x176,
	FHT14_PKT_SPD_DBYTE20_OFS = 0x177,
	FHT14_PKT_SPD_DBYTE21_OFS = 0x178,
	FHT14_PKT_SPD_DBYTE22_OFS = 0x179,
	FHT14_PKT_SPD_DBYTE23_OFS = 0x17a,
	FHT14_PKT_SPD_DBYTE24_OFS = 0x17b,
	FHT14_PKT_SPD_DBYTE25_OFS = 0x17c,
	FHT14_PKT_SPD_DBYTE26_OFS = 0x17d,
	FHT14_PKT_SPD_DBYTE27_OFS = 0x17e,
	FHT14_PKT_AUD_TYPE_OFS = 0x180,
	FHT14_PKT_AUD_VERS_OFS = 0x181,
	FHT14_PKT_AUD_LEN_OFS = 0x182,
	FHT14_PKT_AUD_CHSUM_OFS = 0x183,
	FHT14_PKT_AUD_DBYTE1_OFS = 0x184,
	FHT14_PKT_AUD_DBYTE2_OFS = 0x185,
	FHT14_PKT_AUD_DBYTE3_OFS = 0x186,
	FHT14_PKT_AUD_DBYTE4_OFS = 0x187,
	FHT14_PKT_AUD_DBYTE5_OFS = 0x188,
	FHT14_PKT_AUD_DBYTE6_OFS = 0x189,
	FHT14_PKT_AUD_DBYTE7_OFS = 0x18a,
	FHT14_PKT_AUD_DBYTE8_OFS = 0x18b,
	FHT14_PKT_AUD_DBYTE9_OFS = 0x18c,
	FHT14_PKT_AUD_DBYTE10_OFS = 0x18d,
	FHT14_PKT_MPEG_TYPE_OFS = 0x1a0,
	FHT14_PKT_MPEG_VERS_OFS = 0x1a1,
	FHT14_PKT_MPEG_LEN_OFS = 0x1a2,
	FHT14_PKT_MPEG_CHSUM_OFS = 0x1a3,
	FHT14_PKT_MPEG_DBYTE1_OFS = 0x1a4,
	FHT14_PKT_MPEG_DBYTE2_OFS = 0x1a5,
	FHT14_PKT_MPEG_DBYTE3_OFS = 0x1a6,
	FHT14_PKT_MPEG_DBYTE4_OFS = 0x1a7,
	FHT14_PKT_MPEG_DBYTE5_OFS = 0x1a8,
	FHT14_PKT_MPEG_DBYTE6_OFS = 0x1a9,
	FHT14_PKT_MPEG_DBYTE7_OFS = 0x1aa,
	FHT14_PKT_MPEG_DBYTE8_OFS = 0x1ab,
	FHT14_PKT_MPEG_DBYTE9_OFS = 0x1ac,
	FHT14_PKT_MPEG_DBYTE10_OFS = 0x1ad,
	FHT14_PKT_MPEG_DBYTE11_OFS = 0x1ae,
	FHT14_PKT_MPEG_DBYTE12_OFS = 0x1af,
	FHT14_PKT_MPEG_DBYTE13_OFS = 0x1b0,
	FHT14_PKT_MPEG_DBYTE14_OFS = 0x1b1,
	FHT14_PKT_MPEG_DBYTE15_OFS = 0x1b2,
	FHT14_PKT_MPEG_DBYTE16_OFS = 0x1b3,
	FHT14_PKT_MPEG_DBYTE17_OFS = 0x1b4,
	FHT14_PKT_MPEG_DBYTE18_OFS = 0x1b5,
	FHT14_PKT_MPEG_DBYTE19_OFS = 0x1b6,
	FHT14_PKT_MPEG_DBYTE20_OFS = 0x1b7,
	FHT14_PKT_MPEG_DBYTE21_OFS = 0x1b8,
	FHT14_PKT_MPEG_DBYTE22_OFS = 0x1b9,
	FHT14_PKT_MPEG_DBYTE23_OFS = 0x1ba,
	FHT14_PKT_MPEG_DBYTE24_OFS = 0x1bb,
	FHT14_PKT_MPEG_DBYTE25_OFS = 0x1bc,
	FHT14_PKT_MPEG_DBYTE26_OFS = 0x1bd,
	FHT14_PKT_MPEG_DBYTE27_OFS = 0x1be,
	FHT14_PKT_GEN_DBYTE1_OFS = 0x1c0,
	FHT14_PKT_GEN_DBYTE2_OFS = 0x1c1,
	FHT14_PKT_GEN_DBYTE3_OFS = 0x1c2,
	FHT14_PKT_GEN_DBYTE4_OFS = 0x1c3,
	FHT14_PKT_GEN_DBYTE5_OFS = 0x1c4,
	FHT14_PKT_GEN_DBYTE6_OFS = 0x1c5,
	FHT14_PKT_GEN_DBYTE7_OFS = 0x1c6,
	FHT14_PKT_GEN_DBYTE8_OFS = 0x1c7,
	FHT14_PKT_GEN_DBYTE9_OFS = 0x1c8,
	FHT14_PKT_GEN_DBYTE10_OFS = 0x1c9,
	FHT14_PKT_GEN_DBYTE11_OFS = 0x1ca,
	FHT14_PKT_GEN_DBYTE12_OFS = 0x1cb,
	FHT14_PKT_GEN_DBYTE13_OFS = 0x1cc,
	FHT14_PKT_GEN_DBYTE14_OFS = 0x1cd,
	FHT14_PKT_GEN_DBYTE15_OFS = 0x1ce,
	FHT14_PKT_GEN_DBYTE16_OFS = 0x1cf,
	FHT14_PKT_GEN_DBYTE17_OFS = 0x1d0,
	FHT14_PKT_GEN_DBYTE18_OFS = 0x1d1,
	FHT14_PKT_GEN_DBYTE19_OFS = 0x1d2,
	FHT14_PKT_GEN_DBYTE20_OFS = 0x1d3,
	FHT14_PKT_GEN_DBYTE21_OFS = 0x1d4,
	FHT14_PKT_GEN_DBYTE22_OFS = 0x1d5,
	FHT14_PKT_GEN_DBYTE23_OFS = 0x1d6,
	FHT14_PKT_GEN_DBYTE24_OFS = 0x1d7,
	FHT14_PKT_GEN_DBYTE25_OFS = 0x1d8,
	FHT14_PKT_GEN_DBYTE26_OFS = 0x1d9,
	FHT14_PKT_GEN_DBYTE27_OFS = 0x1da,
	FHT14_PKT_GEN_DBYTE28_OFS = 0x1db,
	FHT14_PKT_GEN_DBYTE29_OFS = 0x1dc,
	FHT14_PKT_GEN_DBYTE30_OFS = 0x1dd,
	FHT14_PKT_GEN_DBYTE31_OFS = 0x1de,
	FHT14_PKT_GP_BYTE1_OFS = 0x1df,
	FHT14_PKT_GEN2_DBYTE1_OFS = 0x1e0,
	FHT14_PKT_GEN2_DBYTE2_OFS = 0x1e1,
	FHT14_PKT_GEN2_DBYTE3_OFS = 0x1e2,
	FHT14_PKT_GEN2_DBYTE4_OFS = 0x1e3,
	FHT14_PKT_GEN2_DBYTE5_OFS = 0x1e4,
	FHT14_PKT_GEN2_DBYTE6_OFS = 0x1e5,
	FHT14_PKT_GEN2_DBYTE7_OFS = 0x1e6,
	FHT14_PKT_GEN2_DBYTE8_OFS = 0x1e7,
	FHT14_PKT_GEN2_DBYTE9_OFS = 0x1e8,
	FHT14_PKT_GEN2_DBYTE10_OFS = 0x1e9,
	FHT14_PKT_GEN2_DBYTE11_OFS = 0x1ea,
	FHT14_PKT_GEN2_DBYTE12_OFS = 0x1eb,
	FHT14_PKT_GEN2_DBYTE13_OFS = 0x1ec,
	FHT14_PKT_GEN2_DBYTE14_OFS = 0x1ed,
	FHT14_PKT_GEN2_DBYTE15_OFS = 0x1ee,
	FHT14_PKT_GEN2_DBYTE16_OFS = 0x1ef,
	FHT14_PKT_GEN2_DBYTE17_OFS = 0x1f0,
	FHT14_PKT_GEN2_DBYTE18_OFS = 0x1f1,
	FHT14_PKT_GEN2_DBYTE19_OFS = 0x1f2,
	FHT14_PKT_GEN2_DBYTE20_OFS = 0x1f3,
	FHT14_PKT_GEN2_DBYTE21_OFS = 0x1f4,
	FHT14_PKT_GEN2_DBYTE22_OFS = 0x1f5,
	FHT14_PKT_GEN2_DBYTE23_OFS = 0x1f6,
	FHT14_PKT_GEN2_DBYTE24_OFS = 0x1f7,
	FHT14_PKT_GEN2_DBYTE25_OFS = 0x1f8,
	FHT14_PKT_GEN2_DBYTE26_OFS = 0x1f9,
	FHT14_PKT_GEN2_DBYTE27_OFS = 0x1fa,
	FHT14_PKT_GEN2_DBYTE28_OFS = 0x1fb,
	FHT14_PKT_GEN2_DBYTE29_OFS = 0x1fc,
	FHT14_PKT_GEN2_DBYTE30_OFS = 0x1fd,
	FHT14_PKT_GEN2_DBYTE31_OFS = 0x1fe,

	/*
	 * notice... this IP only has 9-bit address space but > 512 regs
	 *
	 * registers past here are in "Page 2", register 0xff needs
	 * to be set to 0x01 to access them, the other registers need 0xff set
	 * to 0x00 to be accessed...
	 */

	FHT14_PKTPG2_GAMUT_HEADER1_OFS = 0x0,
	FHT14_PKTPG2_GAMUT_HEADER2_OFS = 0x1,
	FHT14_PKTPG2_GAMUT_HEADER3_OFS = 0x2,
	FHT14_PKTPG2_GAMUT_DBYTE1_OFS = 0x3,
	FHT14_PKTPG2_GAMUT_DBYTE2_OFS = 0x4,
	FHT14_PKTPG2_GAMUT_DBYTE3_OFS = 0x5,
	FHT14_PKTPG2_GAMUT_DBYTE4_OFS = 0x6,
	FHT14_PKTPG2_GAMUT_DBYTE5_OFS = 0x7,
	FHT14_PKTPG2_GAMUT_DBYTE6_OFS = 0x8,
	FHT14_PKTPG2_GAMUT_DBYTE7_OFS = 0x9,
	FHT14_PKTPG2_GAMUT_DBYTE8_OFS = 0xa,
	FHT14_PKTPG2_GAMUT_DBYTE9_OFS = 0xb,
	FHT14_PKTPG2_GAMUT_DBYTE10_OFS = 0xc,
	FHT14_PKTPG2_GAMUT_DBYTE11_OFS = 0xd,
	FHT14_PKTPG2_GAMUT_DBYTE12_OFS = 0xe,
	FHT14_PKTPG2_GAMUT_DBYTE13_OFS = 0xf,
	FHT14_PKTPG2_GAMUT_DBYTE14_OFS = 0x10,
	FHT14_PKTPG2_GAMUT_DBYTE15_OFS = 0x11,
	FHT14_PKTPG2_GAMUT_DBYTE16_OFS = 0x12,
	FHT14_PKTPG2_GAMUT_DBYTE17_OFS = 0x13,
	FHT14_PKTPG2_GAMUT_DBYTE18_OFS = 0x14,
	FHT14_PKTPG2_GAMUT_DBYTE19_OFS = 0x15,
	FHT14_PKTPG2_GAMUT_DBYTE20_OFS = 0x16,
	FHT14_PKTPG2_GAMUT_DBYTE21_OFS = 0x17,
	FHT14_PKTPG2_GAMUT_DBYTE22_OFS = 0x18,
	FHT14_PKTPG2_GAMUT_DBYTE23_OFS = 0x19,
	FHT14_PKTPG2_GAMUT_DBYTE24_OFS = 0x1a,
	FHT14_PKTPG2_GAMUT_DBYTE25_OFS = 0x1b,
	FHT14_PKTPG2_GAMUT_DBYTE26_OFS = 0x1c,
	FHT14_PKTPG2_GAMUT_DBYTE27_OFS = 0x1d,
	FHT14_PKTPG2_GAMUT_DBYTE28_OFS = 0x1e,

	/* CEC not implemented */

};

enum ddc_cmd {
	DDC_CMD__ABORT_TRANSACTION = 0xf,
	DDC_CMD__CLEAR_FIFO = 0x9,
	DDC_CMD__CLOCK_SCL = 0xa,
	DDC_CMD__CUR_READ_NO_ACK_ON_LAST = 0x0,
	DDC_CMD__SEQ_READ_NO_ACK_ON_LAST = 0x2,
	DDC_CMD__ENHANCED_DDC_READ_NO_ACK_ON_LAST = 0x4,
	DDC_CMD__SEQ_WRITE_IGN_ACK_ON_LAST = 0x6,
	DDC_CMD__SEQ_WRITE_REQ_ACK_ON_LAST = 0x7,
};

enum freq_sval_mclk_conf {
	MCLK_CONF_128,
	MCLK_CONF_256,
	MCLK_CONF_384,
	MCLK_CONF_512,
	MCLK_CONF_768,
	MCLK_CONF_1024,
	MCLK_CONF_1152,
	MCLK_CONF_192
};

enum hw_spdif_len {
	HWSPDLEN_UNKNOWN,
	HWSPDLEN_20_16,
	HWSPDLEN_22_18,
	HWSPDLEN_ILLEGAL_3,
	HWSPDLEN_23_19,
	HWSPDLEN_24_20,
	HWSPDLEN_21_17,
	HWSPDLEN_ILLEGAL_7,
};

enum in_length {
	INLEN_ILLEGAL_0,
	INLEN_ILLEGAL_1,
	INLEN_16,
	INLEN_ILLEGAL_3,
	INLEN_18,
	INLEN_22,
	INLEN_ILLEGAL_6,
	INLEN_ILLEGAL_7,
	INLEN_19,
	INLEN_23,
	INLEN_20,
	INLEN_24,
	INLEN_17,
	INLEN_21,
	INLEN_ILLEGAL_14,
	INLEN_ILLEGAL_15
};

enum packet_mode {
	PKTMODE_24 = 4,
	PKTMODE_30 = 5,
	PKTMODE_36 = 6
};


enum {
	FHT14_BASE_SRST__CECRST__SHIFT = 2,
	FHT14_BASE_SRST__CECRST__MASK = 1,
	FHT14_BASE_SRST__FIFORST__SHIFT = 1,
	FHT14_BASE_SRST__FIFORST__MASK = 1,
	FHT14_BASE_SRST__SWRST__SHIFT = 0,
	FHT14_BASE_SRST__SWRST__MASK = 1,

	FHT14_BASE_SYS_CTRL1__VSYNC__SHIFT = 6,
	FHT14_BASE_SYS_CTRL1__VSYNC__MASK = 1,
	FHT14_BASE_SYS_CTRL1__VEN__SHIFT = 5,
	FHT14_BASE_SYS_CTRL1__VEN__MASK = 1,
	FHT14_BASE_SYS_CTRL1__HEN__SHIFT = 4,
	FHT14_BASE_SYS_CTRL1__HEN__MASK = 1,
	FHT14_BASE_SYS_CTRL1__EDGE__SHIFT = 1,
	FHT14_BASE_SYS_CTRL1__EDGE__MASK = 1,
	FHT14_BASE_SYS_CTRL1__NPD__SHIFT = 0,
	FHT14_BASE_SYS_CTRL1__NPD__MASK = 1,

	FHT14_BASE_SYS_STAT__VLOW__SHIFT = 7,
	FHT14_BASE_SYS_STAT__VLOW__MASK = 1,
	FHT14_BASE_SYS_STAT__RSEN__SHIFT = 2,
	FHT14_BASE_SYS_STAT__RSEN__MASK = 1,
	FHT14_BASE_SYS_STAT__HPD__SHIFT = 1,
	FHT14_BASE_SYS_STAT__HPD__MASK = 1,
	FHT14_BASE_SYS_STAT__P_STABLE__SHIFT = 0,
	FHT14_BASE_SYS_STAT__P_STABLE__MASK = 1,

	FHT14_BASE_SYS_CTRL3__CTL__SHIFT = 1,
	FHT14_BASE_SYS_CTRL3__CTL__MASK = 3,

	FHT14_BASE_SYS_DCTL__VID_BLANK__SHIFT = 2,
	FHT14_BASE_SYS_DCTL__VID_BLANK__MASK = 1,
	FHT14_BASE_SYS_DCTL__AUD_MUTE__SHIFT = 1,
	FHT14_BASE_SYS_DCTL__AUD_MUTE__MASK = 1,
	FHT14_BASE_SYS_DCTL__HDCP_SEL__SHIFT = 0,
	FHT14_BASE_SYS_DCTL__HDCP_SEL__MASK = 1,

	FHT14_VDE_DE_DLY__DE_DLY_L__SHIFT = 0,
	FHT14_VDE_DE_DLY__DE_DLY_L__MASK = 0xff,

	FHT14_VDE_DE_CTRL__DE_GEN__SHIFT = 6,
	FHT14_VDE_DE_CTRL__DE_GEN__MASK = 1,
	FHT14_VDE_DE_CTRL__VS_POL__SHIFT = 5,
	FHT14_VDE_DE_CTRL__VS_POL__MASK = 1,
	FHT14_VDE_DE_CTRL__HS_POL__SHIFT = 4,
	FHT14_VDE_DE_CTRL__HS_POL__MASK = 1,
	FHT14_VDE_DE_CTRL__DE_DLY_H__SHIFT = 0,
	FHT14_VDE_DE_CTRL__DE_DLY_H__MASK = 0xf,

	FHT14_VDE_DE_TOP__DE_TOP__SHIFT = 0,
	FHT14_VDE_DE_TOP__DE_TOP__MASK = 0x7f,

	FHT14_VDE_DE_CNTL__DE_CNTL__SHIFT = 0,
	FHT14_VDE_DE_CNTL__DE_CNTL__MASK = 0xff,

	FHT14_VDE_DE_CNTH__DE_CNTH__SHIFT = 0,
	FHT14_VDE_DE_CNTH__DE_CNTH__MASK = 0xf,

	FHT14_VDE_DE_LINL__DE_LINL__SHIFT = 0,
	FHT14_VDE_DE_LINL__DE_LINL__MASK = 0xff,

	FHT14_VDE_DE_LINH__DE_LINH__SHIFT = 0,
	FHT14_VDE_DE_LINH__DE_LINH__MASK = 7,

	FHT14_VDE_DE_HRESH__DE_HRESH__SHIFT = 0,
	FHT14_VDE_DE_HRESH__DE_HRESH__MASK = 0x1f,

	FHT14_VDE_DE_VRESH__DE_VRESH__SHIFT = 0,
	FHT14_VDE_DE_VRESH__DE_VRESH__MASK = 0x3f,

	FHT14_VDE_IADJUST__nDE_ADJ__SHIFT = 2,
	FHT14_VDE_IADJUST__nDE_ADJ__MASK = 1,
	FHT14_VDE_IADJUST__F2VADJ__SHIFT = 1,
	FHT14_VDE_IADJUST__F2VADJ__MASK = 1,
	FHT14_VDE_IADJUST__F2VOFST__SHIFT = 0,
	FHT14_VDE_IADJUST__F2VOFST__MASK = 1,

	FHT14_VDE_POL_DETECT__I_DET__SHIFT = 2,
	FHT14_VDE_POL_DETECT__I_DET__MASK = 1,
	FHT14_VDE_POL_DETECT__nVPOL_DET__SHIFT = 1,
	FHT14_VDE_POL_DETECT__nVPOL_DET__MASK = 1,
	FHT14_VDE_POL_DETECT__nHPOL_DET__SHIFT = 0,
	FHT14_VDE_POL_DETECT__nHPOL_DET__MASK = 1,

	FHT14_VDE_HBIT_TO_HSYNC_H__HIGH2__SHIFT = 0,
	FHT14_VDE_HBIT_TO_HSYNC_H__HIGH2__MASK = 3,

	FHT14_VDE_FIELD2_OFST_H__HIGH4__SHIFT = 0,
	FHT14_VDE_FIELD2_OFST_H__HIGH4__MASK = 0xf,

	FHT14_VDE_HWIDTH_H__HIGH2__SHIFT = 0,
	FHT14_VDE_HWIDTH_H__HIGH2__MASK = 3,
	FHT14_VDE_HWIDTH_L__LOW__SHIFT = 0,
	FHT14_VDE_HWIDTH_L__LOW__MASK = 0xff,

	FHT14_VDE_VBIT_TO_VSYNC__SHIFT = 0,
	FHT14_VDE_VBIT_TO_VSYNC__MASK = 0x3f,

	FHT14_VDE_VWIDTH__WIDTH__SHIFT = 0,
	FHT14_VDE_VWIDTH__WIDTH__MASK = 0x3f,

	FHT14_VDE_VID_CTRL__IFPOL__SHIFT = 7,
	FHT14_VDE_VID_CTRL__IFPOL__MASK = 1,
	FHT14_VDE_VID_CTRL__EXTN__SHIFT = 5,
	FHT14_VDE_VID_CTRL__EXTN__MASK = 1,
	FHT14_VDE_VID_CTRL__CSCSEL__SHIFT = 4,
	FHT14_VDE_VID_CTRL__CSCSEL__MASK = 1,
	FHT14_VDE_VID_CTRL__ICLK__SHIFT = 0,
	FHT14_VDE_VID_CTRL__ICLK__MASK = 3,

	FHT14_VDE_VID_ACEN__WIDE_BUS__SHIFT = 6,
	FHT14_VDE_VID_ACEN__WIDE_BUS__MASK = 3,
	FHT14_VDE_VID_ACEN__CLIP_CS_ID__SHIFT = 4,
	FHT14_VDE_VID_ACEN__CLIP_CS_ID__MASK = 1,
	FHT14_VDE_VID_ACEN__RANGE_CLIP__SHIFT = 3,
	FHT14_VDE_VID_ACEN__RANGE_CLIP__MASK = 1,
	FHT14_VDE_VID_ACEN__RGB_TO_YCBCR__SHIFT = 2,
	FHT14_VDE_VID_ACEN__RGB_TO_YCBCR__MASK = 1,
	FHT14_VDE_VID_ACEN__RANGE_CMPS__SHIFT = 1,
	FHT14_VDE_VID_ACEN__RANGE_CMPS__MASK = 1,
	FHT14_VDE_VID_ACEN__DOWN_SMPL__SHIFT = 0,
	FHT14_VDE_VID_ACEN__DOWN_SMPL__MASK = 1,
	FHT14_VDE_VID_ACEN__VALUE__SHIFT = 0,
	FHT14_VDE_VID_ACEN__VALUE__MASK = 0xff,

	FHT14_VDE_VID_MODE__DITHER_MODE__SHIFT = 6,
	FHT14_VDE_VID_MODE__DITHER_MODE__MASK = 3,
	FHT14_VDE_VID_MODE__DITHER__SHIFT = 5,
	FHT14_VDE_VID_MODE__DITHER__MASK = 1,
	FHT14_VDE_VID_MODE__RANGE__SHIFT = 4,
	FHT14_VDE_VID_MODE__RANGE__MASK = 1,
	FHT14_VDE_VID_MODE__CSC__SHIFT = 3,
	FHT14_VDE_VID_MODE__CSC__MASK = 1,
	FHT14_VDE_VID_MODE__UPSMP__SHIFT = 2,
	FHT14_VDE_VID_MODE__UPSMP__MASK = 1,
	FHT14_VDE_VID_MODE__DEMUX__SHIFT = 1,
	FHT14_VDE_VID_MODE__DEMUX__MASK = 1,
	FHT14_VDE_VID_MODE__SYNCEXT__SHIFT = 0,
	FHT14_VDE_VID_MODE__SYNCEXT__MASK = 1,
	FHT14_VDE_VID_MODE__VALUE__SHIFT = 0,
	FHT14_VDE_VID_MODE__VALUE__MASK = 0xff,

	FHT14_VDE_VID_DITHER__M_D2__SHIFT = 6,
	FHT14_VDE_VID_DITHER__M_D2__MASK = 1,
	FHT14_VDE_VID_DITHER__UP2__SHIFT = 5,
	FHT14_VDE_VID_DITHER__UP2__MASK = 1,
	FHT14_VDE_VID_DITHER__422_EN__SHIFT = 4,
	FHT14_VDE_VID_DITHER__422_EN__MASK = 1,
	FHT14_VDE_VID_DITHER__D_BC_EN__SHIFT = 3,
	FHT14_VDE_VID_DITHER__D_BC_EN__MASK = 1,
	FHT14_VDE_VID_DITHER__D_GC_EN__SHIFT = 2,
	FHT14_VDE_VID_DITHER__D_GC_EN__MASK = 1,
	FHT14_VDE_VID_DITHER__D_RC_EN__SHIFT = 1,
	FHT14_VDE_VID_DITHER__D_RC_EN__MASK = 1,
	FHT14_VDE_VID_DITHER__DRD__SHIFT = 0,
	FHT14_VDE_VID_DITHER__DRD__MASK = 1,

	FHT14_VDE_RGB_TO_XVYVV_CT__XV_CO_OV__SHIFT = 2,
	FHT14_VDE_RGB_TO_XVYVV_CT__XV_CO_OV__MASK = 1,
	FHT14_VDE_RGB_TO_XVYVV_CT__XV_FUS__SHIFT = 1,
	FHT14_VDE_RGB_TO_XVYVV_CT__XV_FUS__MASK = 1,
	FHT14_VDE_RGB_TO_XVYVV_CT__XV_EN__SHIFT = 0,
	FHT14_VDE_RGB_TO_XVYVV_CT__XV_EN__MASK = 1,

	FHT14_VDE_R_TO_Y_COEFF_UP__R_TO_Y_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_R_TO_Y_COEFF_UP__R_TO_Y_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_G_TO_Y_COEFF_UP__G_TO_Y_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_G_TO_Y_COEFF_UP__G_TO_Y_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_B_TO_Y_COEFF_UP__B_TO_Y_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_B_TO_Y_COEFF_UP__B_TO_Y_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_R_TO_CB_COEFF_UP__R_TO_CB_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_R_TO_CB_COEFF_UP__R_TO_CB_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_G_TO_CB_COEFF_UP__G_TO_CB_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_G_TO_CB_COEFF_UP__G_TO_CB_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_B_TO_CB_COEFF_UP__B_TO_CB_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_B_TO_CB_COEFF_UP__B_TO_CB_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_R_TO_CR_COEFF_UP__R_TO_CR_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_R_TO_CR_COEFF_UP__R_TO_CR_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_G_TO_CR_COEFF_UP__G_TO_CR_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_G_TO_CR_COEFF_UP__G_TO_CR_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_B_TO_CR_COEFF_UP__B_TO_CR_COEFF_HIGH__SHIFT = 0,
	FHT14_VDE_B_TO_CR_COEFF_UP__B_TO_CR_COEFF_HIGH__MASK = 0x3f,

	FHT14_VDE_RGB_OFFSET_UP__RGB_OFFSET_HIGH__SHIFT = 0,
	FHT14_VDE_RGB_OFFSET_UP__RGB_OFFSET_HIGH__MASK = 0x3f,

	FHT14_VDE_Y_OFFSET_LOW__Y_OFFSET_LOW__SHIFT = 0,
	FHT14_VDE_Y_OFFSET_LOW__Y_OFFSET_LOW__MASK = 0x7f,

	FHT14_VDE_Y_OFFSET_UP__Y_OFFSET_HIGH__SHIFT = 0,
	FHT14_VDE_Y_OFFSET_UP__Y_OFFSET_HIGH__MASK = 0x7f,

	FHT14_VDE_CBCR_OFFSET_LOW__CBCR_OFFSET_LOW__SHIFT = 0,
	FHT14_VDE_CBCR_OFFSET_LOW__CBCR_OFFSET_LOW__MASK = 0x7f,

	FHT14_VDE_CBCR_OFFSET_UP__CBCR_OFFSET_HIGH__SHIFT = 0,
	FHT14_VDE_CBCR_OFFSET_UP__CBCR_OFFSET_HIGH__MASK = 0x7f,

	FHT14_INTR_INTR_STATE__INTR__SHIFT = 0,
	FHT14_INTR_INTR_STATE__INTR__MASK = 1,

	FHT14_INTR_INTR1__SOFT__SHIFT = 7,
	FHT14_INTR_INTR1__SOFT__MASK = 1,
	FHT14_INTR_INTR1__HPD__SHIFT = 6,
	FHT14_INTR_INTR1__HPD__MASK = 1,
	FHT14_INTR_INTR1__RSEN__SHIFT = 5,
	FHT14_INTR_INTR1__RSEN__MASK = 1,
	FHT14_INTR_INTR1__DROP_SAMPLE__SHIFT = 4,
	FHT14_INTR_INTR1__DROP_SAMPLE__MASK = 1,
	FHT14_INTR_INTR1__BIPHASE_ERROR__SHIFT = 3,
	FHT14_INTR_INTR1__BIPHASE_ERROR__MASK = 1,
	FHT14_INTR_INTR1__RI_128__SHIFT = 2,
	FHT14_INTR_INTR1__RI_128__MASK = 1,
	FHT14_INTR_INTR1__OVERRUN__SHIFT = 1,
	FHT14_INTR_INTR1__OVERRUN__MASK = 1,
	FHT14_INTR_INTR1__UNDERRUN__SHIFT = 0,
	FHT14_INTR_INTR1__UNDERRUN__MASK = 1,

	FHT14_INTR_INTR2__SPDIF_PAR__SHIFT = 6,
	FHT14_INTR_INTR2__SPDIF_PAR__MASK = 1,
	FHT14_INTR_INTR2__ENC_DIS__SHIFT = 5,
	FHT14_INTR_INTR2__ENC_DIS__MASK = 1,
	FHT14_INTR_INTR2__PREAM_ERR__SHIFT = 4,
	FHT14_INTR_INTR2__PREAM_ERR__MASK = 1,
	FHT14_INTR_INTR2__CTS_CHG__SHIFT = 3,
	FHT14_INTR_INTR2__CTS_CHG__MASK = 1,
	FHT14_INTR_INTR2__ACR_OVR__SHIFT = 2,
	FHT14_INTR_INTR2__ACR_OVR__MASK = 1,
	FHT14_INTR_INTR2__TCLK_STBL__SHIFT = 1,
	FHT14_INTR_INTR2__TCLK_STBL__MASK = 1,
	FHT14_INTR_INTR2__VSYNC_REC__SHIFT = 0,
	FHT14_INTR_INTR2__VSYNC_REC__MASK = 1,

	FHT14_INTR_INTR3__RI_ERR3__SHIFT = 7,
	FHT14_INTR_INTR3__RI_ERR3__MASK = 1,
	FHT14_INTR_INTR3__RI_ERR2__SHIFT = 6,
	FHT14_INTR_INTR3__RI_ERR2__MASK = 1,
	FHT14_INTR_INTR3__RI_ERR1__SHIFT = 5,
	FHT14_INTR_INTR3__RI_ERR1__MASK = 1,
	FHT14_INTR_INTR3__RI_ERR0__SHIFT = 4,
	FHT14_INTR_INTR3__RI_ERR0__MASK = 1,
	FHT14_INTR_INTR3__DDC_CMD_DONE__SHIFT = 3,
	FHT14_INTR_INTR3__DDC_CMD_DONE__MASK = 1,
	FHT14_INTR_INTR3__DDC_FIFO_HALF__SHIFT = 2,
	FHT14_INTR_INTR3__DDC_FIFO_HALF__MASK = 1,
	FHT14_INTR_INTR3__DDC_FIFO_FULL__SHIFT = 1,
	FHT14_INTR_INTR3__DDC_FIFO_FULL__MASK = 1,
	FHT14_INTR_INTR3__DDC_FIFO_EMPTY__SHIFT = 0,
	FHT14_INTR_INTR3__DDC_FIFO_EMPTY__MASK = 1,

	FHT14_INTR_INTR4__INTR4_STAT3__SHIFT = 3,
	FHT14_INTR_INTR4__INTR4_STAT3__MASK = 1,
	FHT14_INTR_INTR4__INTR4_STAT2__SHIFT = 2,
	FHT14_INTR_INTR4__INTR4_STAT2__MASK = 1,
	FHT14_INTR_INTR4__INTR4_STAT1__SHIFT = 1,
	FHT14_INTR_INTR4__INTR4_STAT1__MASK = 1,

	FHT14_INTR_INT_UNMASK1__SOFT__SHIFT = 7,
	FHT14_INTR_INT_UNMASK1__SOFT__MASK = 1,
	FHT14_INTR_INT_UNMASK1__HPD__SHIFT = 6,
	FHT14_INTR_INT_UNMASK1__HPD__MASK = 1,
	FHT14_INTR_INT_UNMASK1__RSEN__SHIFT = 5,
	FHT14_INTR_INT_UNMASK1__RSEN__MASK = 1,
	FHT14_INTR_INT_UNMASK1__DROP_SAMPLE__SHIFT = 4,
	FHT14_INTR_INT_UNMASK1__DROP_SAMPLE__MASK = 1,
	FHT14_INTR_INT_UNMASK1__BI_PHASE_ERROR__SHIFT = 3,
	FHT14_INTR_INT_UNMASK1__BI_PHASE_ERROR__MASK = 1,
	FHT14_INTR_INT_UNMASK1__RI_128__SHIFT = 2,
	FHT14_INTR_INT_UNMASK1__RI_128__MASK = 1,
	FHT14_INTR_INT_UNMASK1__OVERRUN__SHIFT = 1,
	FHT14_INTR_INT_UNMASK1__OVERRUN__MASK = 1,
	FHT14_INTR_INT_UNMASK1__UNDERRUN__SHIFT = 0,
	FHT14_INTR_INT_UNMASK1__UNDERRUN__MASK = 1,

	FHT14_INTR_INT_UNMASK2__SPDIF_PAR__SHIFT = 6,
	FHT14_INTR_INT_UNMASK2__SPDIF_PAR__MASK = 1,
	FHT14_INTR_INT_UNMASK2__ENC_DIS__SHIFT = 5,
	FHT14_INTR_INT_UNMASK2__ENC_DIS__MASK = 1,
	FHT14_INTR_INT_UNMASK2__PREAM_ERR__SHIFT = 4,
	FHT14_INTR_INT_UNMASK2__PREAM_ERR__MASK = 1,
	FHT14_INTR_INT_UNMASK2__CTS_CHG__SHIFT = 3,
	FHT14_INTR_INT_UNMASK2__CTS_CHG__MASK = 1,
	FHT14_INTR_INT_UNMASK2__ACR_OVR__SHIFT = 2,
	FHT14_INTR_INT_UNMASK2__ACR_OVR__MASK = 1,
	FHT14_INTR_INT_UNMASK2__TCLK_STBL__SHIFT = 1,
	FHT14_INTR_INT_UNMASK2__TCLK_STBL__MASK = 1,
	FHT14_INTR_INT_UNMASK2__VSYNC_REC__SHIFT = 0,
	FHT14_INTR_INT_UNMASK2__VSYNC_REC__MASK = 1,

	FHT14_INTR_INT_UNMASK3__RI_ERR3__SHIFT = 7,
	FHT14_INTR_INT_UNMASK3__RI_ERR3__MASK = 1,
	FHT14_INTR_INT_UNMASK3__RI_ERR2__SHIFT = 6,
	FHT14_INTR_INT_UNMASK3__RI_ERR2__MASK = 1,
	FHT14_INTR_INT_UNMASK3__RI_ERR1__SHIFT = 5,
	FHT14_INTR_INT_UNMASK3__RI_ERR1__MASK = 1,
	FHT14_INTR_INT_UNMASK3__RI_ERR0__SHIFT = 4,
	FHT14_INTR_INT_UNMASK3__RI_ERR0__MASK = 1,
	FHT14_INTR_INT_UNMASK3__DDC_CMD_DONE__SHIFT = 3,
	FHT14_INTR_INT_UNMASK3__DDC_CMD_DONE__MASK = 1,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_HALF__SHIFT = 2,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_HALF__MASK = 1,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_FULL__SHIFT = 1,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_FULL__MASK = 1,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_EMPTY__SHIFT = 0,
	FHT14_INTR_INT_UNMASK3__DDC_FIFO_EMPTY__MASK = 1,

	FHT14_INTR_INT_UNMASK4__INTR4_STAT3__SHIFT = 3,
	FHT14_INTR_INT_UNMASK4__INTR4_STAT3__MASK = 1,
	FHT14_INTR_INT_UNMASK4__INTR4_STAT2__SHIFT = 2,
	FHT14_INTR_INT_UNMASK4__INTR4_STAT2__MASK = 1,
	FHT14_INTR_INT_UNMASK4__INTR4_STAT1__SHIFT = 1,
	FHT14_INTR_INT_UNMASK4__INTR4_STAT1__MASK = 1,

	FHT14_INTR_INT_CTRL__SOFT_INTR__SHIFT = 3,
	FHT14_INTR_INT_CTRL__SOFT_INTR__MASK = 1,
	FHT14_INTR_INT_CTRL__NPOLARITY__SHIFT = 1,
	FHT14_INTR_INT_CTRL__NPOLARITY__MASK = 1,

	FHT14_TMDS_TMDS_CTRL__TCLKSEL__SHIFT = 5,
	FHT14_TMDS_TMDS_CTRL__TCLKSEL__MASK = 3,

	FHT14_TMDS_XVYCC_TO_RGB_CTL___EXP_ONLY__SHIFT = 4,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___EXP_ONLY__MASK = 1,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___BYP_ALL__SHIFT = 3,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___BYP_ALL__MASK = 1,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___SW_OVR__SHIFT = 2,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___SW_OVR__MASK = 1,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___FULLRANGE__SHIFT = 1,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___FULLRANGE__MASK = 1,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___XVYCCSEL__SHIFT = 0,
	FHT14_TMDS_XVYCC_TO_RGB_CTL___XVYCCSEL__MASK = 1,

	FHT14_TMDS_Y_TO_R_COEFF_UP__Y_TO_R_HIGH__SHIFT = 0,
	FHT14_TMDS_Y_TO_R_COEFF_UP__Y_TO_R_HIGH__MASK = 0xf,

	FHT14_TMDS_CR_TO_R_COEFF_UP__CR_TO_R_HIGH__SHIFT = 0,
	FHT14_TMDS_CR_TO_R_COEFF_UP__CR_TO_R_HIGH__MASK = 0xf,

	FHT14_TMDS_CB_TO_B_COEFF_UP__CB_TO_B_HIGH__SHIFT = 0,
	FHT14_TMDS_CB_TO_B_COEFF_UP__CB_TO_B_HIGH__MASK = 0xf,

	FHT14_TMDS_CR_TO_G_COEFF_UP__CR_TO_G_HIGH__SHIFT = 0,
	FHT14_TMDS_CR_TO_G_COEFF_UP__CR_TO_G_HIGH__MASK = 0xf,

	FHT14_TMDS_CB_TO_G_COEFF_UP__CB_TO_G_HIGH__SHIFT = 0,
	FHT14_TMDS_CB_TO_G_COEFF_UP__CB_TO_G_HIGH__MASK = 0xf,

	FHT14_TMDS_YOFFSET1_UP__YOFFSET1_HIGH__SHIFT = 0,
	FHT14_TMDS_YOFFSET1_UP__YOFFSET1_HIGH__MASK = 0xf,

	FHT14_TMDS_OFFSET2_UP__OFFSET2_HIGH__SHIFT = 0,
	FHT14_TMDS_OFFSET2_UP__OFFSET2_HIGH__MASK = 0xf,

	FHT14_TMDS_DCLEVEL_UP__DCLEVEL_HIGH__SHIFT = 0,
	FHT14_TMDS_DCLEVEL_UP__DCLEVEL_HIGH__MASK = 0x3f,

	FHT14_DDC_DDC_MAN__SDA__SHIFT = 1,
	FHT14_DDC_DDC_MAN__SDA__MASK = 1,
	FHT14_DDC_DDC_MAN__SCL__SHIFT = 0,
	FHT14_DDC_DDC_MAN__SCL__MASK = 1,

	FHT14_DDC_DDC_ADDR__ADDR__SHIFT = 0,
	FHT14_DDC_DDC_ADDR__ADDR__MASK = 0xff,

	FHT14_DDC_DDC_SEGM__SEGM__SHIFT = 0,
	FHT14_DDC_DDC_SEGM__SEGM__MASK = 0xff,

	FHT14_DDC_DDC_OFFSET__OFFSET__SHIFT = 0,
	FHT14_DDC_DDC_OFFSET__OFFSET__MASK = 0xff,

	FHT14_DDC_DDC_COUNT_LOW__COUNT1__SHIFT = 0,
	FHT14_DDC_DDC_COUNT_LOW__COUNT1__MASK = 0xff,

	FHT14_DDC_DDC_COUNT_UP__COUNT2__SHIFT = 0,
	FHT14_DDC_DDC_COUNT_UP__COUNT2__MASK = 3,

	FHT14_DDC_DDC_STATUS__BUS_LOW__SHIFT = 6,
	FHT14_DDC_DDC_STATUS__BUS_LOW__MASK = 1,
	FHT14_DDC_DDC_STATUS__NO_ACK__SHIFT = 5,
	FHT14_DDC_DDC_STATUS__NO_ACK__MASK = 1,
	FHT14_DDC_DDC_STATUS__IN_PROG__SHIFT = 4,
	FHT14_DDC_DDC_STATUS__IN_PROG__MASK = 1,
	FHT14_DDC_DDC_STATUS__FIFO_FULL__SHIFT = 3,
	FHT14_DDC_DDC_STATUS__FIFO_FULL__MASK = 1,
	FHT14_DDC_DDC_STATUS__FIFO_EMPTY__SHIFT = 2,
	FHT14_DDC_DDC_STATUS__FIFO_EMPTY__MASK = 1,
	FHT14_DDC_DDC_STATUS__FIFO_READ_USE__SHIFT = 1,
	FHT14_DDC_DDC_STATUS__FIFO_READ_USE__MASK = 1,
	FHT14_DDC_DDC_STATUS__FIFO_WRITE_USE__SHIFT = 0,
	FHT14_DDC_DDC_STATUS__FIFO_WRITE_USE__MASK = 1,

	FHT14_DDC_DDC_CMD__SDA_DEL_EN__SHIFT = 5,
	FHT14_DDC_DDC_CMD__SDA_DEL_EN__MASK = 1,
	FHT14_DDC_DDC_CMD__DDC_FLT_EN__SHIFT = 4,
	FHT14_DDC_DDC_CMD__DDC_FLT_EN__MASK = 1,
	FHT14_DDC_DDC_CMD__DDC_CMD__SHIFT = 0,
	FHT14_DDC_DDC_CMD__DDC_CMD__MASK = 0xf,

	FHT14_DDC_DDC_DATA__DDC_DATA__SHIFT = 0,
	FHT14_DDC_DDC_DATA__DDC_DATA__MASK = 0xff,

	FHT14_DDC_DDC_FIFOCNT__FIFOCONT__SHIFT = 0,
	FHT14_DDC_DDC_FIFOCNT__FIFOCONT__MASK = 0x1f,

	FHT14_REG_REG_BANK0__SELBANK2__SHIFT = 0,
	FHT14_REG_REG_BANK0__SELBANK2__MASK = 1,


	FHT14_ACR_ACR_CTRL__NCTS_PKT_EN__SHIFT = 1,
	FHT14_ACR_ACR_CTRL__NCTS_PKT_EN__MASK = 1,
	FHT14_ACR_ACR_CTRL__CTS_SEL__SHIFT = 0,
	FHT14_ACR_ACR_CTRL__CTS_SEL__MASK = 1,

	FHT14_ACR_FREQ_SVAL__MCLK_CONF__SHIFT = 0,
	FHT14_ACR_FREQ_SVAL__MCLK_CONF__MASK = 7,

	FHT14_ACR_N_SVAL_UP__N_SVAL_HIGH__SHIFT = 0,
	FHT14_ACR_N_SVAL_UP__N_SVAL_HIGH__MASK = 0xf,

	FHT14_ACR_CTS_SVAL_UP__CTS_SVAL_HIGH__SHIFT = 0,
	FHT14_ACR_CTS_SVAL_UP__CTS_SVAL_HIGH__MASK = 0xf,

	FHT14_ACR_CTS_HVAL_UP__CTS_HVAL_HIGH__SHIFT = 0,
	FHT14_ACR_CTS_HVAL_UP__CTS_HVAL_HIGH__MASK = 0xf,

	FHT14_ACRIN_AUD_MODE__SD3_EN__SHIFT = 7,
	FHT14_ACRIN_AUD_MODE__SD3_EN__MASK = 1,
	FHT14_ACRIN_AUD_MODE__SD2_EN__SHIFT = 6,
	FHT14_ACRIN_AUD_MODE__SD2_EN__MASK = 1,
	FHT14_ACRIN_AUD_MODE__SD1_EN__SHIFT = 5,
	FHT14_ACRIN_AUD_MODE__SD1_EN__MASK = 1,
	FHT14_ACRIN_AUD_MODE__SD0_EN__SHIFT = 4,
	FHT14_ACRIN_AUD_MODE__SD0_EN__MASK = 1,
	FHT14_ACRIN_AUD_MODE__SPDIF_EN__SHIFT = 1,
	FHT14_ACRIN_AUD_MODE__SPDIF_EN__MASK = 1,
	FHT14_ACRIN_AUD_MODE__AUD_EN__SHIFT = 0,
	FHT14_ACRIN_AUD_MODE__AUD_EN__MASK = 1,

	FHT14_ACRIN_SPDIF_CTRL__NOAUDIO__SHIFT = 3,
	FHT14_ACRIN_SPDIF_CTRL__NOAUDIO__MASK = 1,
	FHT14_ACRIN_SPDIF_CTRL__FS_OVERRIDE__SHIFT = 1,
	FHT14_ACRIN_SPDIF_CTRL__FS_OVERRIDE__MASK = 1,

	FHT14_ACRIN_HW_SPDIF_FS__HW_SPDIF_LEN__SHIFT = 5,
	FHT14_ACRIN_HW_SPDIF_FS__HW_SPDIF_LEN__MASK = 7,
	FHT14_ACRIN_HW_SPDIF_FS__HW_MAXLEN_24__SHIFT = 4,
	FHT14_ACRIN_HW_SPDIF_FS__HW_MAXLEN_24__MASK = 1,
	FHT14_ACRIN_HW_SPDIF_FS__HW_SPDIF_FS__SHIFT = 0,
	FHT14_ACRIN_HW_SPDIF_FS__HW_SPDIF_FS__MASK = 0xf,

	FHT14_ACRIN_SWAPI2S__SWAP_CH3__SHIFT = 7,
	FHT14_ACRIN_SWAPI2S__SWAP_CH3__MASK = 1,
	FHT14_ACRIN_SWAPI2S__SWAP_CH2__SHIFT = 6,
	FHT14_ACRIN_SWAPI2S__SWAP_CH2__MASK = 1,
	FHT14_ACRIN_SWAPI2S__SWAP_CH1__SHIFT = 5,
	FHT14_ACRIN_SWAPI2S__SWAP_CH1__MASK = 1,
	FHT14_ACRIN_SWAPI2S__SWAP_CH0__SHIFT = 4,
	FHT14_ACRIN_SWAPI2S__SWAP_CH0__MASK = 1,

	FHT14_ACRIN_SPDIF_ERTH__AUD_ERR_THRESHOLD__SHIFT = 0,
	FHT14_ACRIN_SPDIF_ERTH__AUD_ERR_THRESHOLD__MASK = 0x3f,

	FHT14_ACRIN_I2S_IN_MAP__FIFO3_MAP__SHIFT = 6,
	FHT14_ACRIN_I2S_IN_MAP__FIFO3_MAP__MASK = 3,
	FHT14_ACRIN_I2S_IN_MAP__FIFO2_MAP__SHIFT = 4,
	FHT14_ACRIN_I2S_IN_MAP__FIFO2_MAP__MASK = 3,
	FHT14_ACRIN_I2S_IN_MAP__FIFO1_MAP__SHIFT = 2,
	FHT14_ACRIN_I2S_IN_MAP__FIFO1_MAP__MASK = 3,
	FHT14_ACRIN_I2S_IN_MAP__FIFO0_MAP__SHIFT = 0,
	FHT14_ACRIN_I2S_IN_MAP__FIFO0_MAP__MASK = 3,

	FHT14_ACRIN_I2S_IN_CTRL__HBRA_ON__SHIFT = 7,
	FHT14_ACRIN_I2S_IN_CTRL__HBRA_ON__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__SCK_EDGE__SHIFT = 6,
	FHT14_ACRIN_I2S_IN_CTRL__SCK_EDGE__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__CBIT_ORDER__SHIFT = 5,
	FHT14_ACRIN_I2S_IN_CTRL__CBIT_ORDER__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__VBIT__SHIFT = 4,
	FHT14_ACRIN_I2S_IN_CTRL__VBIT__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_WS__SHIFT = 3,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_WS__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_JUST__SHIFT = 2,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_JUST__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_DIR__SHIFT = 1,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_DIR__MASK = 1,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_SHIFT__SHIFT = 0,
	FHT14_ACRIN_I2S_IN_CTRL__I2S_SHIFT__MASK = 1,

	FHT14_ACRIN_I2S_CHST3__I2S_CHAN_NUM__SHIFT = 4,
	FHT14_ACRIN_I2S_CHST3__I2S_CHAN_NUM__MASK = 0xf,
	FHT14_ACRIN_I2S_CHST3__I2S_SRC_NUM__SHIFT = 0,
	FHT14_ACRIN_I2S_CHST3__I2S_SRC_NUM__MASK = 0xf,

	FHT14_ACRIN_I2S_CHST4__CLK_ACCUR__SHIFT = 4,
	FHT14_ACRIN_I2S_CHST4__CLK_ACCUR__MASK = 0xf,
	FHT14_ACRIN_I2S_CHST4__SW_SPDIF_FS__SHIFT = 0,
	FHT14_ACRIN_I2S_CHST4__SW_SPDIF_FS__MASK = 0xf,

	FHT14_ACRIN_I2S_CHST5__FS_ORIG__SHIFT = 4,
	FHT14_ACRIN_I2S_CHST5__FS_ORIG__MASK = 0xf,
	FHT14_ACRIN_I2S_CHST5__I2S_LEN__SHIFT = 1,
	FHT14_ACRIN_I2S_CHST5__I2S_LEN__MASK = 7,
	FHT14_ACRIN_I2S_CHST5__I2S_MAXLEN_24__SHIFT = 0,
	FHT14_ACRIN_I2S_CHST5__I2S_MAXLEN_24__MASK = 1,

	FHT14_ACRIN_ASRC__HBR_SPR_MASK__SHIFT = 4,
	FHT14_ACRIN_ASRC__HBR_SPR_MASK__MASK = 0xf,
	FHT14_ACRIN_ASRC__RATIO__SHIFT = 1,
	FHT14_ACRIN_ASRC__RATIO__MASK = 1,
	FHT14_ACRIN_ASRC__SRC_EN__SHIFT = 0,
	FHT14_ACRIN_ASRC__SRC_EN__MASK = 1,

	FHT14_ACRIN_I2S_IN_LEN__HBT_PKT_ID__SHIFT = 4,
	FHT14_ACRIN_I2S_IN_LEN__HBT_PKT_ID__MASK = 0xf,
	FHT14_ACRIN_I2S_IN_LEN__IN_LENGTH__SHIFT = 0,
	FHT14_ACRIN_I2S_IN_LEN__IN_LENGTH__MASK = 0xf,

	FHT14_ACR_HDMI_CTRL__DC_EN__SHIFT = 6,
	FHT14_ACR_HDMI_CTRL__DC_EN__MASK = 1,
	FHT14_ACR_HDMI_CTRL__PACKET_MODE__SHIFT = 3,
	FHT14_ACR_HDMI_CTRL__PACKET_MODE__MASK = 7,
	FHT14_ACR_HDMI_CTRL__LAYOUT__SHIFT = 1,
	FHT14_ACR_HDMI_CTRL__LAYOUT__MASK = 3,
	FHT14_ACR_HDMI_CTRL__HDMI_MODE__SHIFT = 0,
	FHT14_ACR_HDMI_CTRL__HDMI_MODE__MASK = 1,

	FHT14_ACR_AUDO_TXSTAT__MUTE__SHIFT = 2,
	FHT14_ACR_AUDO_TXSTAT__MUTE__MASK = 1,

	FHT14_ACR_DPD__NTCLK_PHASE__SHIFT = 3,
	FHT14_ACR_DPD__NTCLK_PHASE__MASK = 1,
	FHT14_ACR_DPD__NPOWERDOWN_IDCK__SHIFT = 2,
	FHT14_ACR_DPD__NPOWERDOWN_IDCK__MASK = 1,
	FHT14_ACR_DPD__NPOWERDOWN_OSC__SHIFT = 1,
	FHT14_ACR_DPD__NPOWERDOWN_OSC__MASK = 1,
	FHT14_ACR_DPD__NPOWERDOWN_TOTAL__SHIFT = 0,
	FHT14_ACR_DPD__NPOWERDOWN_TOTAL__MASK = 1,

	FHT14_PKT_PB_CTRL1__MPEG_EN__SHIFT = 7,
	FHT14_PKT_PB_CTRL1__MPEG_EN__MASK = 1,
	FHT14_PKT_PB_CTRL1__MPEG_REPEAT__SHIFT = 6,
	FHT14_PKT_PB_CTRL1__MPEG_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL1__AUD_EN__SHIFT = 5,
	FHT14_PKT_PB_CTRL1__AUD_EN__MASK = 1,
	FHT14_PKT_PB_CTRL1__AUD_REPEAT__SHIFT = 4,
	FHT14_PKT_PB_CTRL1__AUD_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL1__SPD_EN__SHIFT = 3,
	FHT14_PKT_PB_CTRL1__SPD_EN__MASK = 1,
	FHT14_PKT_PB_CTRL1__SPD_REPEAT__SHIFT = 2,
	FHT14_PKT_PB_CTRL1__SPD_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL1__AVI_EN__SHIFT = 1,
	FHT14_PKT_PB_CTRL1__AVI_EN__MASK = 1,
	FHT14_PKT_PB_CTRL1__AVI_REPEAT__SHIFT = 0,
	FHT14_PKT_PB_CTRL1__AVI_REPEAT__MASK = 1,

	FHT14_PKT_PB_CTRL2__GAMUT_EN__SHIFT = 7,
	FHT14_PKT_PB_CTRL2__GAMUT_EN__MASK = 1,
	FHT14_PKT_PB_CTRL2__GAMUT_REPEAT__SHIFT = 6,
	FHT14_PKT_PB_CTRL2__GAMUT_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL2__GEN2_EN__SHIFT = 5,
	FHT14_PKT_PB_CTRL2__GEN2_EN__MASK = 1,
	FHT14_PKT_PB_CTRL2__GEN2_REPEAT__SHIFT = 4,
	FHT14_PKT_PB_CTRL2__GEN2_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL2__CP_EN__SHIFT = 3,
	FHT14_PKT_PB_CTRL2__CP_EN__MASK = 1,
	FHT14_PKT_PB_CTRL2__CP_REPEAT__SHIFT = 2,
	FHT14_PKT_PB_CTRL2__CP_REPEAT__MASK = 1,
	FHT14_PKT_PB_CTRL2__GEN_EN__SHIFT = 1,
	FHT14_PKT_PB_CTRL2__GEN_EN__MASK = 1,
	FHT14_PKT_PB_CTRL2__GEN_REPEAT__SHIFT = 0,
	FHT14_PKT_PB_CTRL2__GEN_REPEAT__MASK = 1,

	FHT14_PKT_GP_BYTE1__CLRAVM__SHIFT = 4,
	FHT14_PKT_GP_BYTE1__CLRAVM__MASK = 0x1,
	FHT14_PKT_GP_BYTE1__SETAVM__SHIFT = 0,
	FHT14_PKT_GP_BYTE1__SETAVM__MASK = 0x1,
	FHT14_PKT_GP_BYTE1__AVM__SHIFT = 0,
	FHT14_PKT_GP_BYTE1__AVM__MASK = 0x11,
};

/* INFOFRAME_AVI_ and INFOFRAME_AUDIO_ definitions */
enum fdb_hdmi_infoframe {
	HDMI_INFOFRAME_AVI_DB1Y_RGB = 0,
	HDMI_INFOFRAME_AVI_DB1Y_YUV422 = 1,
	HDMI_INFOFRAME_AVI_DB1Y_YUV444 = 2,
	HDMI_INFOFRAME_AVI_DB1A_ACTIVE_FORMAT_OFF = 0,
	HDMI_INFOFRAME_AVI_DB1A_ACTIVE_FORMAT_ON =  1,
	HDMI_INFOFRAME_AVI_DB1B_NO = 0,
	HDMI_INFOFRAME_AVI_DB1B_VERT = 1,
	HDMI_INFOFRAME_AVI_DB1B_HORI = 2,
	HDMI_INFOFRAME_AVI_DB1B_VERTHORI = 3,
	HDMI_INFOFRAME_AVI_DB1S_0 = 0,
	HDMI_INFOFRAME_AVI_DB1S_1 = 1,
	HDMI_INFOFRAME_AVI_DB1S_2 = 2,
	HDMI_INFOFRAME_AVI_DB2C_NO = 0,
	HDMI_INFOFRAME_AVI_DB2C_ITU601 = 1,
	HDMI_INFOFRAME_AVI_DB2C_ITU709 = 2,
	HDMI_INFOFRAME_AVI_DB2C_EC_EXTENDED = 3,
	HDMI_INFOFRAME_AVI_DB2M_NO = 0,
	HDMI_INFOFRAME_AVI_DB2M_43 = 1,
	HDMI_INFOFRAME_AVI_DB2M_169 = 2,
	HDMI_INFOFRAME_AVI_DB2R_SAME = 8,
	HDMI_INFOFRAME_AVI_DB2R_43 = 9,
	HDMI_INFOFRAME_AVI_DB2R_169 = 10,
	HDMI_INFOFRAME_AVI_DB2R_149 = 11,
	HDMI_INFOFRAME_AVI_DB3ITC_NO = 0,
	HDMI_INFOFRAME_AVI_DB3ITC_YES = 1,
	HDMI_INFOFRAME_AVI_DB3EC_XVYUV601 = 0,
	HDMI_INFOFRAME_AVI_DB3EC_XVYUV709 = 1,
	HDMI_INFOFRAME_AVI_DB3Q_DEFAULT = 0,
	HDMI_INFOFRAME_AVI_DB3Q_LR = 1,
	HDMI_INFOFRAME_AVI_DB3Q_FR = 2,
	HDMI_INFOFRAME_AVI_DB3SC_NO = 0,
	HDMI_INFOFRAME_AVI_DB3SC_HORI = 1,
	HDMI_INFOFRAME_AVI_DB3SC_VERT = 2,
	HDMI_INFOFRAME_AVI_DB3SC_HORIVERT = 3,
	HDMI_INFOFRAME_AVI_DB5PR_NO = 0,
	HDMI_INFOFRAME_AVI_DB5PR_2 = 1,
	HDMI_INFOFRAME_AVI_DB5PR_3 = 2,
	HDMI_INFOFRAME_AVI_DB5PR_4 = 3,
	HDMI_INFOFRAME_AVI_DB5PR_5 = 4,
	HDMI_INFOFRAME_AVI_DB5PR_6 = 5,
	HDMI_INFOFRAME_AVI_DB5PR_7 = 6,
	HDMI_INFOFRAME_AVI_DB5PR_8 = 7,
	HDMI_INFOFRAME_AVI_DB5PR_9 = 8,
	HDMI_INFOFRAME_AVI_DB5PR_10 = 9,
};

enum hdmi_signal_level {
	HDMI_TX14_ACTIVE_HIGH	= 0,
	HDMI_TX14_ACTIVE_LOW		= 1,
};

enum hdmi_deepcolor_ed {
	HDMI_DEEPCOLORPACKECTDISABLE = 0,
	HDMI_DEEPCOLORPACKECTENABLE = 1
};

enum hdmi_packet_mode {
	HDMI_PACKETMODERESERVEDVALUE = 0,
	HDMI_PACKETMODE24BITPERPIXEL = 4,
	HDMI_PACKETMODE30BITPERPIXEL = 5,
	HDMI_PACKETMODE36BITPERPIXEL = 6,
};

enum hdmi_dvi_mode {
	HDMI_DVI = 0,
	HDMI_HDMI = 1,
};
#if 0
enum hdmi_packing_mode {
	HDMI_PACK_RESERVED = 0,
	HDMI_PACK_24BIT_PER_PIXEL = 4,
	HDMI_PACK_30BIT_PER_PIXEL = 5,
	HDMI_PACK_36BIT_PER_PIXEL = 6,
};
#endif
enum hdmi_bus_width {
	HDMI_INPUT_8BIT = 0,
	HDMI_INPUT_10BIT = (1 << 6),
	HDMI_INPUT_12BIT = (2 << 6),
};

enum hdmi_clip_color_space {
	HDMI_OUTPUT_RGB = 0,
	HDMI_OUTPUT_YCBCR = (1 << 4),
};

enum hdmi_range_clip {
	HDMI_RANGECLIP_DISABLE = 0,
	HDMI_RANGECLIP_ENALBE = (1 << 3),
};

enum hdmi_rgbtoycbcr {
	HDMI_RBG2YCBCR_DISABLE = 0,
	HDMI_RBG2YCBCR_ENABLE = (1 << 2),
};

enum hdmi_range_compress {
	HDMI_RANGECMPS_DISABLE = 0,
	HDMI_RANGECMPS_ENABLE = (1 << 1),
};

/* down sample 444 to 422 */
enum hdmi_downsample {
	HDMI_DOWNSAMPLE_DISABLE = 0,
	HDMI_DOWNSAMPLE_ENABLE = 1,
};

enum hdmi_dither_mode {
	HDMI_OUTPUTDITHER_8BIT = 0,
	HDMI_OUTPUTDITHER_10BIT = (1 << 6),
	HDMI_OUTPUTDITHER_12BIT = (2 << 6),
};

enum hdmi_dither_enable {
	HDMI_DITHER_DISABLE = 0,
	HDMI_DITHER_ENABLE = (1 << 5),
};

enum hdmi_data_range {
	HDMI_RANGE_DISABLE = 0,
	HDMI_RANGE_ENABLE = (1 << 4),
};

enum hdmi_color_space_conv {
	HDMI_YCBCR2RGB_DISABLE = 0,
	HDMI_YCBCR2RGB_ENABLE = (1 << 3),
};

enum hdmi_upsample_422to444 {
	HDMI_UPSAMPLE_DISABLE = 0,
	HDMI_UPSAMPLE_ENABLE = (1 << 2),
};

enum hdmi_demux {
	HDMI_DEMUX_DISABLE = 0,
	HDMI_DEMUX_ENABLE = (1 << 1),
};

enum hdmi_sync_extract {
	HDMI_SYNCEXTRAT_DISABLE = 0,
	HDMI_SYNCEXTRAT_ENABLE = 1,
};

enum hdmi_tclkselclkmult {
	HDMI_FPLL05IDCK = 0,
	HDMI_FPLL10IDCK = 1,
	HDMI_FPLL20IDCK = 2,
	HDMI_FPLL40IDCK = 3
};

enum hdmi_packet_ctrl {
	HDMI_PACKETENABLE = 1,
	HDMI_PACKETDISABLE = 0,
	HDMI_PACKETREPEATON = 1,
	HDMI_PACKETREPEATOFF = 0
};

enum hdmi_audio_layout {
	HDMI_AUDIO_LAYOUT_2CH = 0,
	HDMI_AUDIO_LAYOUT_8CH = 1
};

enum hdmi_cts_mode {
	HDMI_AUDIO_CTS_MODE_HW = 0,
	HDMI_AUDIO_CTS_MODE_SW = 1
};

enum hdmi_stereo_channels {
	HDMI_AUDIO_STEREO_NOCHANNELS = 0,
	HDMI_AUDIO_STEREO_ONECHANNEL = 1,
	HDMI_AUDIO_STEREO_TWOCHANNELS = 2,
	HDMI_AUDIO_STEREO_THREECHANNELS = 3,
	HDMI_AUDIO_STEREO_FOURCHANNELS = 4
};

enum hdmi_audio_type {
	HDMI_AUDIO_TYPE_LPCM = 0,
	HDMI_AUDIO_TYPE_IEC = 1
};

enum hdmi_audio_justify {
	HDMI_AUDIO_JUSTIFY_LEFT = 0,
	HDMI_AUDIO_JUSTIFY_RIGHT = 1
};

enum hdmi_audio_sample_rate {
	HDMI_AUDIO_SAMPLE_RATE_44K = 0,
	HDMI_AUDIO_SAMPLE_RATE_48K = 2,
	HDMI_AUDIO_SAMPLE_RATE_32K = 3,
	HDMI_AUDIO_SAMPLE_RATE_88K = 8,
	HDMI_AUDIO_SAMPLE_RATE_96K = 10,
	HDMI_AUDIO_SAMPLE_RATE_176K = 12,
	HDMI_AUDIO_SAMPLE_RATE_192K = 14,
};

enum hdmi_audio_sample_order {
	HDMI_AUDIO_SAMPLE_RIGHT_FIRST = 0,
	HDMI_AUDIO_SAMPLE_LEFT_FIRST = 1
};

enum hdmi_audio_samples_perword {
	HDMI_AUDIO_ONEWORD_ONESAMPLE = 0,
	HDMI_AUDIO_ONEWORD_TWOSAMPLES = 1
};

enum fdb_hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_16BITS = 2,
	HDMI_AUDIO_SAMPLE_24BITS = 11
};

enum hdmi_audio_blk_strt_end_sig {
	HDMI_AUDIO_BLOCK_SIG_STARTEND_ON = 0,
	HDMI_AUDIO_BLOCK_SIG_STARTEND_OFF = 1
};

enum hdmi_audio_mclk_mode {
	HDMI_AUDIO_MCLK_128FS = 0,
	HDMI_AUDIO_MCLK_256FS = 1,
	HDMI_AUDIO_MCLK_384FS = 2,
	HDMI_AUDIO_MCLK_512FS = 3,
	HDMI_AUDIO_MCLK_768FS = 4,
	HDMI_AUDIO_MCLK_1024FS = 5,
	HDMI_AUDIO_MCLK_1152FS = 6,
	HDMI_AUDIO_MCLK_192FS = 7
};

enum hdmi_audio_i2s_config {
	HDMI_AUDIO_I2S_MSB_SHIFTED_FIRST = 0,
	HDMI_AUDIO_I2S_LSB_SHIFTED_FIRST = 1,
	HDMI_AUDIO_I2S_SCK_EDGE_FALLING = 0,
	HDMI_AUDIO_I2S_SCK_EDGE_RISING = 1,
	HDMI_AUDIO_I2S_VBIT_FOR_PCM = 0,
	HDMI_AUDIO_I2S_VBIT_FOR_COMPRESSED = 1,
	HDMI_AUDIO_I2S_FIRST_BIT_SHIFT = 0,
	HDMI_AUDIO_I2S_FIRST_BIT_NO_SHIFT = 1,
	HDMI_AUDIO_I2S_SD0_EN = 1 << 4,
	HDMI_AUDIO_I2S_SD1_EN = 1 << 5,
	HDMI_AUDIO_I2S_SD2_EN = 1 << 6,
	HDMI_AUDIO_I2S_SD3_EN = 1 << 7,
};

struct f_hdmi_cm {
	int	code;
	int	mode;
};

struct f_hdmi_config {
	struct fdb_video_timings timings;
	struct f_hdmi_cm cm;
};

struct f_hdmi_video_config {
	enum hdmi_sync_extract		syncext;
	enum hdmi_demux			demux;
	enum hdmi_upsample_422to444	upsmp;
	enum hdmi_color_space_conv	csc;
	enum hdmi_data_range		range;
	enum hdmi_dither_enable		dither;
	enum hdmi_dither_mode		dithmode;
	enum hdmi_downsample		downsmp;
	enum hdmi_range_compress	rangcmps;
	enum hdmi_rgbtoycbcr			rgb2ycbcr;
	enum hdmi_range_clip			rangclip;
	enum hdmi_clip_color_space	clipcs;
	enum hdmi_bus_width			buswidth;
	enum hdmi_dvi_mode			hdmi_dvi;
	enum hdmi_packet_mode		pkt_mode;
	enum hdmi_deepcolor_ed		deep_color;
	enum hdmi_tclkselclkmult		tclk_sel_clkmult;
};

struct f_hdmi_infoframe_avi {
	/* Y0, Y1 rgb,yCbCr */
	u8	db1_format;
	/* A0  Active information Present */
	u8	db1_active_info;
	/* B0, B1 Bar info data valid */
	u8	db1_bar_info_dv;
	/* S0, S1 scan information */
	u8	db1_scan_info;
	/* C0, C1 colorimetry */
	u8	db2_colorimetry;
	/* M0, M1 Aspect ratio (4:3, 16:9) */
	u8	db2_aspect_ratio;
	/* R0...R3 Active format aspect ratio */
	u8	db2_active_fmt_ar;
	/* ITC IT content. */
	u8	db3_itc;
	/* EC0, EC1, EC2 Extended colorimetry */
	u8	db3_ec;
	/* Q1, Q0 Quantization range */
	u8	db3_q_range;
	/* SC1, SC0 Non-uniform picture scaling */
	u8	db3_nup_scaling;
	/* VIC0..6 Video format identification */
	u8	db4_videocode;
	/* PR0..PR3 Pixel repetition factor */
	u8	db5_pixel_repeat;
	/* Line number end of top bar */
	u16	db6_7_line_eoftop;
	/* Line number start of bottom bar */
	u16	db8_9_line_sofbottom;
	/* Pixel number end of left bar */
	u16	db10_11_pixel_eofleft;
	/* Pixel number start of right bar */
	u16	db12_13_pixel_sofright;
};

struct f_hdmi_packet_enable_repeat {
	u32	audio_pkt;
	u32	audio_pkt_repeat;
	u32	avi_infoframe;
	u32	avi_infoframe_repeat;
	u32	gen_cntrl_pkt;
	u32	gen_cntrl_pkt_repeat;
	u32	generic_pkt;
	u32	generic_pkt_repeat;
};

struct f_hdmi_audio_format {
	enum hdmi_stereo_channels		stereo_channels;
	u8					active_chnnls_msk;
	enum hdmi_audio_type			type;
	enum hdmi_audio_justify			justification;
	enum hdmi_audio_sample_order		sample_order;
	enum hdmi_audio_samples_perword		samples_per_word;
	enum hdmi_audio_sample_size		sample_size;
	enum hdmi_audio_sample_rate		sample_rate;
	/*enum hdmi_audio_blk_strt_end_sig	en_sig_blk_strt_end;*/
};

struct f_hdmi_audio_i2s_config {
	u8 in_length_bits;
	u8 justification;
	u8 sck_edge_mode;
	u8 vbit;
	u8 direction;
	u8 shift;
	u8 active_sds;
};

struct f_hdmi_audio_config {
	struct f_hdmi_audio_i2s_config	i2s_cfg;
	/*struct snd_aes_iec958			*iec60958_cfg;*/
	bool					fs_override;
	u32					n;
	u32					cts;
	u32					aud_par_busclk;
	enum hdmi_audio_layout		layout;
	enum hdmi_cts_mode			cts_mode;
	bool					use_mclk;
	enum hdmi_audio_mclk_mode		mclk_mode;
	bool					en_acr_pkt;
	bool					en_dsd_audio;
	bool					en_parallel_aud_input;
	/*bool					en_spdif;*/
};


#define EDID_SLV       0xA0
/*----------------------------------------------------------
 *	VIDEO CONFIG
 *---------------------------------------------------------- */
#if 0
/*
 * Logic for the below structure :
 * user enters the CEA or VESA timings by specifying the HDMI/DVI code.
 * There is a correspondence between CEA/VESA timing and code, please
 * refer to section 6.3 in HDMI 1.3 specification for timing code.
 *
 * In the below structure, cea_vesa_timings corresponds to all F_HDMI
 * supported CEA and VESA timing values.code_cea corresponds to the CEA
 * code, It is used to get the timing from cea_vesa_timing array.Similarly
 * with code_vesa. Code_index is used for back mapping, that is once EDID
 * is read from the TV, EDID is parsed to find the timing values and then
 * map it to corresponding CEA or VESA index.
 */
#if 1

#endif
#if 0
static const struct hdmi_config vesa_timings[] = {
/* VESA From Here */
	{
		{ 640, 480, 25175, 96, 16, 48, 2, 11, 31,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 4, HDMI_DVI },
	},
	{
		{ 800, 600, 40000, 128, 40, 88, 4, 1, 23,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 9, HDMI_DVI },
	},
	{
		{ 848, 480, 33750, 112, 16, 112, 8, 6, 23,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0xE, HDMI_DVI },
	},
	{
		{ 1280, 768, 79500, 128, 64, 192, 7, 3, 20,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x17, HDMI_DVI },
	},
	{
		{ 1280, 800, 83500, 128, 72, 200, 6, 3, 22,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x1C, HDMI_DVI },
	},
	{
		{ 1360, 768, 85500, 112, 64, 256, 6, 3, 18,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x27, HDMI_DVI },
	},
	{
		{ 1280, 960, 108000, 112, 96, 312, 3, 1, 36,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x20, HDMI_DVI },
	},
	{
		{ 1280, 1024, 108000, 112, 48, 248, 3, 1, 38,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x23, HDMI_DVI },
	},
	{
		{ 1024, 768, 65000, 136, 24, 160, 6, 3, 29,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x10, HDMI_DVI },
	},
	{
		{ 1400, 1050, 121750, 144, 88, 232, 4, 3, 32,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x2A, HDMI_DVI },
	},
	{
		{ 1440, 900, 106500, 152, 80, 232, 6, 3, 25,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x2F, HDMI_DVI },
	},
	{
		{ 1680, 1050, 146250, 176 , 104, 280, 6, 3, 30,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_LOW,
			false, },
		{ 0x3A, HDMI_DVI },
	},
	{
		{ 1366, 768, 85500, 143, 70, 213, 3, 3, 24,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x51, HDMI_DVI },
	},
	{
		{ 1920, 1080, 148500, 44, 148, 80, 5, 4, 36,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x52, HDMI_DVI },
	},
	{
		{ 1280, 768, 68250, 32, 48, 80, 7, 3, 12,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x16, HDMI_DVI },
	},
	{
		{ 1400, 1050, 101000, 32, 48, 80, 4, 3, 23,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x29, HDMI_DVI },
	},
	{
		{ 1680, 1050, 119000, 32, 48, 80, 6, 3, 21,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x39, HDMI_DVI },
	},
	{
		{ 1280, 800, 79500, 32, 48, 80, 6, 3, 14,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x1B, HDMI_DVI },
	},
	{
		{ 1280, 720, 74250, 40, 110, 220, 5, 5, 20,
			OMAPDSS_SIG_ACTIVE_HIGH, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x55, HDMI_DVI },
	},
	{
		{ 1920, 1200, 154000, 32, 48, 80, 6, 3, 26,
			OMAPDSS_SIG_ACTIVE_LOW, OMAPDSS_SIG_ACTIVE_HIGH,
			false, },
		{ 0x44, HDMI_DVI },
	},
};
#endif
#endif

#endif
